/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.ModelDataTextureMapper;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.TextureMapper;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.TexturedBlockStateModel;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.TexturedModelBaker;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.neoforged.neoforge.client.model.block.CustomBlockModelDefinition;

public record TexturedBlockModelDefinition(BlockModelDefinition baseModelDefinition) implements CustomBlockModelDefinition
{
    public static final MapCodec<TexturedBlockModelDefinition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockModelDefinition.VANILLA_CODEC.forGetter(TexturedBlockModelDefinition::baseModelDefinition)).apply((Applicative)instance, TexturedBlockModelDefinition::new));

    private static TextureMapper createTextureMapper() {
        return new ModelDataTextureMapper();
    }

    public Map<BlockState, BlockStateModel.UnbakedRoot> instantiate(StateDefinition<Block, BlockState> states, Supplier<String> sourceSupplier) {
        TextureMapper textureMapper = TexturedBlockModelDefinition.createTextureMapper();
        Map instantiatedBase = this.baseModelDefinition.instantiate(states, sourceSupplier);
        for (Map.Entry entry : instantiatedBase.entrySet()) {
            entry.setValue(TexturedBlockModelDefinition.wrapTextured((BlockStateModel.UnbakedRoot)entry.getValue(), textureMapper));
        }
        return instantiatedBase;
    }

    public MapCodec<? extends CustomBlockModelDefinition> codec() {
        return CODEC;
    }

    private static BlockStateModel.UnbakedRoot wrapTextured(final BlockStateModel.UnbakedRoot base, final TextureMapper textureMapper) {
        return new BlockStateModel.UnbakedRoot(){

            public BlockStateModel bake(BlockState state, ModelBaker baker) {
                TexturedModelBaker texturedBaker = new TexturedModelBaker(baker);
                return new TexturedBlockStateModel(base.bake(state, (ModelBaker)texturedBaker), textureMapper, texturedBaker.sprites());
            }

            public Object visualEqualityGroup(BlockState state) {
                return base.visualEqualityGroup(state);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
                base.resolveDependencies(resolver);
            }
        };
    }
}

