/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.PropertySprite;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.TextureMapper;
import com.tomboshoven.minecraft.magicdoorknob.modeldata.TextureSourceReference;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

class TexturedBlockModelPart
implements BlockModelPart {
    private final BlockModelPart original;
    private final SpriteGetter sprites;
    private final TextureMapper.BlockStateTextureMapper textureMapper;
    private final RandomSource randomSource;
    private static final VertexFormat VERTEX_FORMAT = DefaultVertexFormat.BLOCK;

    TexturedBlockModelPart(BlockModelPart original, TextureMapper.BlockStateTextureMapper textureMapper, SpriteGetter sprites, RandomSource randomSource) {
        this.original = original;
        this.sprites = sprites;
        this.textureMapper = textureMapper;
        this.randomSource = randomSource;
    }

    public List<BakedQuad> getQuads(@Nullable Direction direction) {
        List quads = this.original.getQuads(direction);
        return quads.stream().map(quad -> {
            TextureAtlasSprite sprite = quad.sprite();
            if (sprite instanceof PropertySprite) {
                PropertySprite property = (PropertySprite)sprite;
                TextureSourceReference textureSourceReference = this.textureMapper.mapSprite(property);
                if (textureSourceReference != null) {
                    TextureSourceReference.LookupResult lookupResult = textureSourceReference.lookup(this.sprites, quad.direction(), this.randomSource);
                    return TexturedBlockModelPart.retexture(quad, lookupResult.sprite(), lookupResult.tintIndex());
                }
                return null;
            }
            return quad;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static BakedQuad retexture(BakedQuad quad, TextureAtlasSprite sprite, @Nullable Integer tintIndex) {
        int[] vertexData = (int[])quad.vertices().clone();
        int stride = VERTEX_FORMAT.getVertexSize();
        int eltOffset = VertexFormatElement.UV0.type().size();
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        int idx = VERTEX_FORMAT.getOffset(VertexFormatElement.UV0);
        for (int vertex = 0; vertex < 4; ++vertex) {
            float vertexU = Float.intBitsToFloat(TexturedBlockModelPart.getAtByteOffset(vertexData, idx));
            float vertexV = Float.intBitsToFloat(TexturedBlockModelPart.getAtByteOffset(vertexData, idx + eltOffset));
            float newU = minU + (maxU - minU) * vertexU;
            float newV = minV + (maxV - minV) * vertexV;
            TexturedBlockModelPart.putAtByteOffset(vertexData, idx, Float.floatToRawIntBits(newU));
            TexturedBlockModelPart.putAtByteOffset(vertexData, idx + eltOffset, Float.floatToRawIntBits(newV));
            idx += stride;
        }
        return new BakedQuad(vertexData, tintIndex == null ? quad.tintIndex() : tintIndex.intValue(), quad.direction(), sprite, quad.shade(), quad.lightEmission(), quad.hasAmbientOcclusion());
    }

    private static int getAtByteOffset(int[] inData, int offset) {
        int index = offset / 4;
        int lsb = inData[index];
        int shift = offset % 4 * 8;
        if (shift == 0) {
            return inData[index];
        }
        int msb = inData[index + 1];
        return lsb >>> shift | msb << 32 - shift;
    }

    private static void putAtByteOffset(int[] outData, int offset, int value) {
        int index = offset / 4;
        int shift = offset % 4 * 8;
        if (shift == 0) {
            outData[index] = value;
            return;
        }
        int lsbMask = -1 >>> 32 - shift;
        int msbMask = -1 << shift;
        outData[index] = outData[index] & lsbMask | value << shift;
        outData[index + 1] = outData[index + 1] & msbMask | value >>> 32 - shift;
    }

    public boolean useAmbientOcclusion() {
        return this.original.useAmbientOcclusion();
    }

    public TextureAtlasSprite particleIcon() {
        PropertySprite property;
        TextureSourceReference textureSourceReference;
        TextureAtlasSprite icon = this.original.particleIcon();
        if (icon instanceof PropertySprite && (textureSourceReference = this.textureMapper.mapSprite(property = (PropertySprite)icon)) != null) {
            return textureSourceReference.lookup(this.sprites, this.randomSource).sprite();
        }
        return icon;
    }

    public ChunkSectionLayer getRenderType(BlockState state) {
        return this.original.getRenderType(state);
    }
}

