/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured;

import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.PropertySprite;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.TextureMapper;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.TexturedBlockModelPart;
import com.tomboshoven.minecraft.magicdoorknob.modeldata.TextureSourceReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.DelegateBlockStateModel;
import net.neoforged.neoforge.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class TexturedBlockStateModel
extends DelegateBlockStateModel {
    private final TextureMapper textureMapper;
    private final SpriteGetter sprites;
    private final ConcurrentHashMap<Object, List<BlockModelPart>> partCache = new ConcurrentHashMap();

    public TexturedBlockStateModel(BlockStateModel baseModel, TextureMapper textureMapper, SpriteGetter sprites) {
        super(baseModel);
        this.textureMapper = textureMapper;
        this.sprites = sprites;
    }

    @Nullable
    public Object createGeometryKey(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
        Object baseKey = this.delegate.createGeometryKey(level, pos, state, random);
        if (baseKey == null) {
            return null;
        }
        ModelData modelData = level.getModelData(pos);
        Object mappingKey = this.textureMapper.forBlockState(state, modelData).getMappingKey();
        if (mappingKey == null) {
            return null;
        }
        return new GeometryKey(baseKey, mappingKey);
    }

    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        TextureMapper.BlockStateTextureMapper mapper = this.textureMapper.forBlockState(state, level.getModelData(pos));
        List delegatePartList = this.partCache.computeIfAbsent(mapper.getMappingKey(), key -> {
            ArrayList partList = new ArrayList();
            this.delegate.collectParts(level, pos, state, random, partList);
            partList.replaceAll(part -> this.wrapPart((BlockModelPart)part, mapper, random));
            return partList;
        });
        parts.addAll(delegatePartList);
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        TextureAtlasSprite baseIcon = this.delegate.particleIcon(level, pos, state);
        if (baseIcon instanceof PropertySprite) {
            PropertySprite baseIconProperty = (PropertySprite)baseIcon;
            ModelData modelData = level.getModelData(pos);
            TextureSourceReference textureSourceReference = this.textureMapper.forBlockState(state, modelData).mapSprite(baseIconProperty);
            if (textureSourceReference != null) {
                return textureSourceReference.lookup(this.sprites).sprite();
            }
        }
        return baseIcon;
    }

    private BlockModelPart wrapPart(BlockModelPart basePart, TextureMapper.BlockStateTextureMapper mapper, RandomSource random) {
        return new TexturedBlockModelPart(basePart, mapper, this.sprites, random);
    }

    private record GeometryKey(Object baseKey, Object mappingKey) {
    }
}

