/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.data;

import com.mojang.math.Quadrant;
import com.tomboshoven.minecraft.magicdoorknob.blocks.Blocks;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayPartBaseBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.entities.MagicDoorwayPartBaseBlockEntity;
import com.tomboshoven.minecraft.magicdoorknob.data.textured.TexturedBlockModelGenerator;
import com.tomboshoven.minecraft.magicdoorknob.items.Items;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.template.ElementBuilder;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplate;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;
import net.neoforged.neoforge.client.model.generators.template.FaceBuilder;
import net.neoforged.neoforge.registries.DeferredItem;

class Models
extends ModelProvider {
    private static final TextureSlot MAIN_TEXTURE = TextureSlot.create((String)"main");
    private static final TextureSlot HIGHLIGHT_TEXTURE = TextureSlot.create((String)"highlight");

    private static Consumer<ElementBuilder> wallCuboid(Direction wall, int x1, int y1, int x2, int y2, BiConsumer<Direction, FaceBuilder> faceAction, Function<? super Direction, Boolean> renderEdge) {
        return elementBuilder -> {
            int x2M;
            switch (wall) {
                case DOWN: {
                    elementBuilder.from((float)x1, 0.0f, (float)(16 - y2)).to((float)x2, 1.0f, (float)(16 - y1));
                    break;
                }
                case UP: {
                    elementBuilder.from((float)x1, 15.0f, (float)y1).to((float)x2, 16.0f, (float)y2);
                    break;
                }
                case NORTH: {
                    elementBuilder.from((float)(16 - x2), (float)(16 - y2), 0.0f).to((float)(16 - x1), (float)(16 - y1), 1.0f);
                    break;
                }
                case SOUTH: {
                    elementBuilder.from((float)x1, (float)(16 - y2), 15.0f).to((float)x2, (float)(16 - y1), 16.0f);
                    break;
                }
                case WEST: {
                    elementBuilder.from(0.0f, (float)(16 - y2), (float)x1).to(1.0f, (float)(16 - y1), (float)x2);
                    break;
                }
                case EAST: {
                    elementBuilder.from(15.0f, (float)(16 - y2), (float)(16 - x2)).to(16.0f, (float)(16 - y1), (float)(16 - x1));
                }
            }
            Direction top = switch (wall) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> Direction.SOUTH;
                case Direction.UP -> Direction.NORTH;
                case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
            };
            Direction bottom = top.getOpposite();
            Direction left = switch (wall) {
                default -> throw new MatchException(null, null);
                case Direction.UP, Direction.DOWN -> Direction.WEST;
                case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> wall.getClockWise();
            };
            Direction right = left.getOpposite();
            boolean mirror = wall.getAxis() == Direction.Axis.Z;
            int x1M = mirror ? x1 : 16 - x1;
            int n = x2M = mirror ? x2 : 16 - x2;
            if (((Boolean)renderEdge.apply(Direction.NORTH)).booleanValue()) {
                elementBuilder.face(wall, faceBuilder -> faceBuilder.uvs((float)x1M, (float)y1, (float)x2M, (float)y2).cullface(wall));
            }
            if (((Boolean)renderEdge.apply(Direction.SOUTH)).booleanValue()) {
                elementBuilder.face(wall.getOpposite(), faceBuilder -> faceBuilder.uvs((float)x2M, (float)y1, (float)x1M, (float)y2).rotation(wall.getAxis() == Direction.Axis.Y ? Quadrant.R180 : Quadrant.R0));
            }
            if (((Boolean)renderEdge.apply(Direction.UP)).booleanValue()) {
                elementBuilder.face(top, faceBuilder -> {
                    FaceBuilder faceBuilder2 = faceBuilder.uvs((float)x1M, (float)y1, (float)x2M, (float)(y1 + 1));
                    FaceBuilder fb = faceBuilder2.rotation(switch (wall) {
                        default -> throw new MatchException(null, null);
                        case Direction.SOUTH, Direction.DOWN -> Quadrant.R0;
                        case Direction.EAST -> Quadrant.R270;
                        case Direction.NORTH, Direction.UP -> Quadrant.R180;
                        case Direction.WEST -> Quadrant.R90;
                    });
                    if (y1 == 0) {
                        fb.cullface(top);
                    }
                });
            }
            if (((Boolean)renderEdge.apply(Direction.DOWN)).booleanValue()) {
                elementBuilder.face(bottom, faceBuilder -> {
                    FaceBuilder faceBuilder2 = faceBuilder.uvs((float)x1M, (float)y2, (float)x2M, (float)(y2 - 1));
                    FaceBuilder fb = faceBuilder2.rotation(switch (wall) {
                        default -> throw new MatchException(null, null);
                        case Direction.SOUTH, Direction.UP -> Quadrant.R0;
                        case Direction.WEST -> Quadrant.R270;
                        case Direction.NORTH, Direction.DOWN -> Quadrant.R180;
                        case Direction.EAST -> Quadrant.R90;
                    });
                    if (y2 == 16) {
                        fb.cullface(bottom);
                    }
                });
            }
            if (((Boolean)renderEdge.apply(Direction.WEST)).booleanValue()) {
                elementBuilder.face(left, faceBuilder -> {
                    FaceBuilder faceBuilder2 = faceBuilder.uvs((float)x1M, (float)y1, mirror ? (float)(x1 + 1) : (float)(16 - x1 - 1), (float)y2);
                    FaceBuilder fb = faceBuilder2.rotation(switch (wall) {
                        default -> throw new MatchException(null, null);
                        case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Quadrant.R0;
                        case Direction.UP -> Quadrant.R270;
                        case Direction.DOWN -> Quadrant.R90;
                    });
                    if (x1 == 0) {
                        fb.cullface(left);
                    }
                });
            }
            if (((Boolean)renderEdge.apply(Direction.EAST)).booleanValue()) {
                elementBuilder.face(right, faceBuilder -> {
                    FaceBuilder faceBuilder2 = faceBuilder.uvs((float)x2M, (float)y1, mirror ? (float)(x2 - 1) : (float)(16 - x2 + 1), (float)y2);
                    FaceBuilder fb = faceBuilder2.rotation(switch (wall) {
                        default -> throw new MatchException(null, null);
                        case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Quadrant.R0;
                        case Direction.DOWN -> Quadrant.R270;
                        case Direction.UP -> Quadrant.R90;
                    });
                    if (x2 != 16) {
                        fb.cullface(right);
                    }
                });
            }
            elementBuilder.faces(faceAction);
        };
    }

    private static Consumer<ElementBuilder> panelCuboid(Direction wall, int x1, int y1, int x2, int y2, BiConsumer<Direction, FaceBuilder> faceAction, Function<? super Direction, Boolean> renderEdge) {
        return Models.wallCuboid(wall, x1, y1, x2, y2, faceAction, d -> {
            boolean bl;
            block11: {
                block10: {
                    if (!((Boolean)renderEdge.apply((Direction)d)).booleanValue()) break block10;
                    switch (d) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case NORTH: 
                        case SOUTH: {
                            break;
                        }
                        case UP: {
                            if (y1 == 0) {
                                break;
                            }
                            break block10;
                        }
                        case DOWN: {
                            if (y2 == 16) {
                                break;
                            }
                            break block10;
                        }
                        case WEST: {
                            if (x1 == 0) {
                                break;
                            }
                            break block10;
                        }
                        case EAST: {
                            if (x2 != 16) break block10;
                        }
                    }
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            return bl;
        });
    }

    private static Consumer<ElementBuilder> panelCuboid(Direction wall, int x1, int y1, int x2, int y2, BiConsumer<Direction, FaceBuilder> faceAction) {
        return Models.panelCuboid(wall, x1, y1, x2, y2, faceAction, d -> true);
    }

    private static Consumer<ElementBuilder> pillarCuboid(Direction wall, int y1, int y2, BiConsumer<Direction, FaceBuilder> faceAction, Function<? super Direction, Boolean> renderEdge) {
        return Models.wallCuboid(wall, 0, y1, 1, y2, faceAction, d -> {
            boolean bl;
            block7: {
                block6: {
                    if (!((Boolean)renderEdge.apply((Direction)d)).booleanValue()) break block6;
                    switch (d) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case NORTH: 
                        case SOUTH: 
                        case WEST: 
                        case EAST: {
                            break;
                        }
                        case UP: {
                            if (y1 == 0) {
                                break;
                            }
                            break block6;
                        }
                        case DOWN: {
                            if (y2 != 16) break block6;
                        }
                    }
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            return bl;
        });
    }

    private static Consumer<ElementBuilder> pillarCuboid(Direction wall, int y1, int y2, BiConsumer<Direction, FaceBuilder> faceAction) {
        return Models.pillarCuboid(wall, y1, y2, faceAction, d -> true);
    }

    private static Consumer<ElementBuilder> top(BiConsumer<Direction, FaceBuilder> faceAction) {
        return elementBuilder -> elementBuilder.from(0.0f, 15.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces(faceAction).allFaces((d, faceBuilder) -> {
            if (d != Direction.DOWN) {
                faceBuilder.cullface(d);
            }
        });
    }

    private static Consumer<ElementBuilder> stretchCuboid(float x1, float y1, float z1, float x2, float y2, float z2, TextureSlot texture) {
        return elementBuilder -> elementBuilder.from(x1, y1, z1).to(x2, y2, z2).textureAll(texture).face(Direction.NORTH, builder -> builder.uvs(x2, y1, x1, y2)).face(Direction.SOUTH, builder -> builder.uvs(x1, y1, x2, y2)).face(Direction.EAST, builder -> builder.uvs(x2, y1, x2 - 0.01f, y2)).face(Direction.WEST, builder -> builder.uvs(x1, y1, x1 + 0.01f, y2)).face(Direction.UP, builder -> builder.uvs(x1, y1, x2, y1 + 0.01f)).face(Direction.DOWN, builder -> builder.uvs(x1, y2, x2, y2 - 0.01f));
    }

    private static ExtendedModelTemplate doorknobBaseTemplate(ResourceLocation blockModelLocation) {
        return ExtendedModelTemplateBuilder.builder().parent(blockModelLocation).element(Models.stretchCuboid(3.0f, 3.0f, 7.0f, 13.0f, 13.0f, 10.0f, MAIN_TEXTURE)).element(Models.stretchCuboid(3.0f, 2.0f, 8.0f, 13.0f, 14.0f, 9.0f, MAIN_TEXTURE)).element(Models.stretchCuboid(2.0f, 3.0f, 8.0f, 14.0f, 13.0f, 9.0f, MAIN_TEXTURE)).element(Models.stretchCuboid(4.0f, 4.0f, 6.0f, 12.0f, 12.0f, 7.0f, MAIN_TEXTURE)).element(Models.stretchCuboid(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 15.0f, MAIN_TEXTURE)).build();
    }

    private static ExtendedModelTemplate doorknobTemplate(ResourceLocation doorKnobBaseModelLocation) {
        return ExtendedModelTemplateBuilder.builder().parent(doorKnobBaseModelLocation).requiredTextureSlot(MAIN_TEXTURE).build();
    }

    private static ExtendedModelTemplate doorTemplate(MagicDoorwayPartBaseBlock.EnumPartType partType) {
        Function<Direction, Boolean> renderEdge = switch (partType) {
            default -> throw new MatchException(null, null);
            case MagicDoorwayPartBaseBlock.EnumPartType.TOP -> d -> d != Direction.DOWN;
            case MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM -> d -> d != Direction.UP;
        };
        BiConsumer<Direction, FaceBuilder> mainTextureAction = (d, faceBuilder) -> faceBuilder.texture(MAIN_TEXTURE).tintindex(1);
        BiConsumer<Direction, FaceBuilder> highlightTextureAction = (d, faceBuilder) -> faceBuilder.texture(HIGHLIGHT_TEXTURE);
        ExtendedModelTemplateBuilder builder = ExtendedModelTemplateBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/block")).renderType("translucent").requiredTextureSlot(MAIN_TEXTURE).requiredTextureSlot(HIGHLIGHT_TEXTURE).requiredTextureSlot(TextureSlot.PARTICLE).element(Models.panelCuboid(Direction.EAST, 0, 0, 1, 7, mainTextureAction, renderEdge)).element(Models.panelCuboid(Direction.EAST, 1, 0, 2, 7, highlightTextureAction, renderEdge)).element(Models.panelCuboid(Direction.EAST, 2, 0, 3, 7, mainTextureAction, renderEdge)).element(Models.panelCuboid(Direction.EAST, 3, 0, 4, 7, highlightTextureAction, renderEdge)).element(Models.panelCuboid(Direction.EAST, 4, 0, 16, 7, mainTextureAction, renderEdge)).element(Models.panelCuboid(Direction.EAST, 0, 7, 16, 8, highlightTextureAction)).element(Models.panelCuboid(Direction.EAST, 0, 8, 1, 9, mainTextureAction)).element(Models.panelCuboid(Direction.EAST, 1, 8, 2, 9, highlightTextureAction)).element(Models.panelCuboid(Direction.EAST, 2, 8, 3, 9, mainTextureAction)).element(Models.panelCuboid(Direction.EAST, 3, 8, 4, 9, highlightTextureAction)).element(Models.panelCuboid(Direction.EAST, 4, 8, 16, 9, mainTextureAction)).element(Models.panelCuboid(Direction.EAST, 0, 9, 16, 10, highlightTextureAction)).element(Models.panelCuboid(Direction.EAST, 0, 10, 1, 16, mainTextureAction, renderEdge)).element(Models.panelCuboid(Direction.EAST, 1, 10, 2, 16, highlightTextureAction, renderEdge)).element(Models.panelCuboid(Direction.EAST, 2, 10, 3, 16, mainTextureAction, renderEdge)).element(Models.panelCuboid(Direction.EAST, 3, 10, 4, 16, highlightTextureAction, renderEdge)).element(Models.panelCuboid(Direction.EAST, 4, 10, 16, 16, mainTextureAction, renderEdge));
        if (partType == MagicDoorwayPartBaseBlock.EnumPartType.TOP) {
            builder.element(eb -> eb.from(17.0f, -1.0f, 1.0f).to(18.0f, 2.0f, 4.0f).face(Direction.NORTH, fb -> fb.uvs(16.0f, 0.0f, 0.0f, 16.0f)).face(Direction.SOUTH, fb -> fb.uvs(16.0f, 0.0f, 0.0f, 16.0f)).face(Direction.UP, fb -> fb.uvs(16.0f, 0.0f, 0.0f, 16.0f).rotation(Quadrant.R90)).face(Direction.DOWN, fb -> fb.uvs(16.0f, 0.0f, 0.0f, 16.0f).rotation(Quadrant.R270)).face(Direction.EAST, fb -> fb.uvs(0.0f, 0.0f, 16.0f, 16.0f)).face(Direction.WEST, fb -> fb.uvs(0.0f, 0.0f, 16.0f, 16.0f)).faces((d, fb) -> fb.cullface(Direction.EAST)).texture(HIGHLIGHT_TEXTURE)).element(eb -> eb.from(16.0f, 0.0f, 2.0f).to(17.0f, 1.0f, 3.0f).face(Direction.UP, fb -> fb.uvs(5.3333335f, 5.3333335f, 10.666667f, 10.666667f).rotation(Quadrant.R90)).face(Direction.DOWN, fb -> fb.uvs(5.3333335f, 5.3333335f, 10.666667f, 10.666667f).rotation(Quadrant.R270)).face(Direction.NORTH, fb -> fb.uvs(5.3333335f, 5.3333335f, 10.666667f, 10.666667f)).face(Direction.SOUTH, fb -> fb.uvs(5.3333335f, 5.3333335f, 10.666667f, 10.666667f)).faces((d, fb) -> fb.cullface(Direction.EAST)).texture(HIGHLIGHT_TEXTURE));
        }
        return builder.build();
    }

    private static ExtendedModelTemplate closedDoorwayTemplate(MagicDoorwayPartBaseBlock.EnumPartType partType) {
        int startY;
        BiConsumer<Direction, FaceBuilder> mainTextureAction = (d, faceBuilder) -> faceBuilder.texture(MAIN_TEXTURE).tintindex(1);
        BiConsumer<Direction, FaceBuilder> highlightTextureAction = (d, faceBuilder) -> faceBuilder.texture(HIGHLIGHT_TEXTURE);
        ExtendedModelTemplateBuilder builder = ExtendedModelTemplateBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/block")).renderType("translucent").requiredTextureSlot(MAIN_TEXTURE).requiredTextureSlot(HIGHLIGHT_TEXTURE).requiredTextureSlot(TextureSlot.PARTICLE);
        if (partType == MagicDoorwayPartBaseBlock.EnumPartType.TOP) {
            startY = 1;
            builder.element(Models.top(mainTextureAction));
        } else {
            startY = 0;
        }
        Direction.stream().filter(d -> d.getAxis() != Direction.Axis.Y).forEach(wall -> {
            int startX = wall.getAxis() == Direction.Axis.Z ? 1 : 0;
            int endX = wall.getAxis() == Direction.Axis.Z ? 15 : 16;
            builder.element(Models.panelCuboid(wall, startX, startY, endX, 7, mainTextureAction)).element(Models.panelCuboid(wall, startX, 7, endX, 8, highlightTextureAction)).element(Models.panelCuboid(wall, startX, 8, endX, 9, mainTextureAction)).element(Models.panelCuboid(wall, startX, 9, endX, 10, highlightTextureAction)).element(Models.panelCuboid(wall, startX, 10, endX, 16, mainTextureAction));
        });
        return builder.build();
    }

    private static ExtendedModelTemplate halfOpenDoorwayTemplate(MagicDoorwayPartBaseBlock.EnumPartType partType) {
        int startY;
        BiConsumer<Direction, FaceBuilder> mainTextureAction = (d, faceBuilder) -> faceBuilder.texture(MAIN_TEXTURE).tintindex(1);
        BiConsumer<Direction, FaceBuilder> highlightTextureAction = (d, faceBuilder) -> faceBuilder.texture(HIGHLIGHT_TEXTURE);
        ExtendedModelTemplateBuilder builder = ExtendedModelTemplateBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/block")).renderType("translucent").requiredTextureSlot(MAIN_TEXTURE).requiredTextureSlot(HIGHLIGHT_TEXTURE).requiredTextureSlot(TextureSlot.PARTICLE);
        if (partType == MagicDoorwayPartBaseBlock.EnumPartType.TOP) {
            startY = 1;
            builder.element(Models.top(mainTextureAction));
        } else {
            startY = 0;
        }
        Direction.stream().filter(d -> d.getAxis() == Direction.Axis.Z).forEach(wall -> builder.element(Models.panelCuboid(wall, 0, startY, 16, 7, mainTextureAction)).element(Models.panelCuboid(wall, 0, 7, 16, 8, highlightTextureAction)).element(Models.panelCuboid(wall, 0, 8, 16, 9, mainTextureAction)).element(Models.panelCuboid(wall, 0, 9, 16, 10, highlightTextureAction)).element(Models.panelCuboid(wall, 0, 10, 16, 16, mainTextureAction)));
        return builder.build();
    }

    private static ExtendedModelTemplate openDoorwayTemplate(MagicDoorwayPartBaseBlock.EnumPartType partType) {
        int startY;
        BiConsumer<Direction, FaceBuilder> mainTextureAction = (d, faceBuilder) -> faceBuilder.texture(MAIN_TEXTURE).tintindex(1);
        BiConsumer<Direction, FaceBuilder> highlightTextureAction = (d, faceBuilder) -> faceBuilder.texture(HIGHLIGHT_TEXTURE);
        ExtendedModelTemplateBuilder builder = ExtendedModelTemplateBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/block")).renderType("translucent").requiredTextureSlot(MAIN_TEXTURE).requiredTextureSlot(HIGHLIGHT_TEXTURE).requiredTextureSlot(TextureSlot.PARTICLE);
        if (partType == MagicDoorwayPartBaseBlock.EnumPartType.TOP) {
            startY = 1;
            builder.element(Models.top(mainTextureAction));
        } else {
            startY = 0;
        }
        Direction.stream().filter(d -> d.getAxis() != Direction.Axis.Y).forEach(wall -> builder.element(Models.pillarCuboid(wall, startY, 7, mainTextureAction)).element(Models.pillarCuboid(wall, 7, 8, highlightTextureAction)).element(Models.pillarCuboid(wall, 8, 9, mainTextureAction)).element(Models.pillarCuboid(wall, 9, 10, highlightTextureAction)).element(Models.pillarCuboid(wall, 10, 16, mainTextureAction)));
        return builder.build();
    }

    Models(PackOutput packOutput) {
        super(packOutput, "magic_doorknob");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        ResourceLocation doorknobBaseModelLocation = this.modLocation("item/magic_doorknob");
        ResourceLocation doorTopModelLocation = this.modLocation("block/magic_door_top");
        ResourceLocation doorBottomModelLocation = this.modLocation("block/magic_door_bottom");
        ResourceLocation doorwayClosedTopModelLocation = this.modLocation("block/magic_doorway_closed_top");
        ResourceLocation doorwayClosedBottomModelLocation = this.modLocation("block/magic_doorway_closed_bottom");
        ResourceLocation doorwayHalfOpenTopModelLocation = this.modLocation("block/magic_doorway_half_open_top");
        ResourceLocation doorwayHalfOpenBottomModelLocation = this.modLocation("block/magic_doorway_half_open_bottom");
        ResourceLocation doorwayOpenTopModelLocation = this.modLocation("block/magic_doorway_open_top");
        ResourceLocation doorwayOpenBottomModelLocation = this.modLocation("block/magic_doorway_open_bottom");
        Models.doorknobBaseTemplate(this.mcLocation("block/block")).create(doorknobBaseModelLocation, new TextureMapping(), itemModels.modelOutput);
        ExtendedModelTemplate doorknobTemplate = Models.doorknobTemplate(doorknobBaseModelLocation);
        for (DeferredItem<MagicDoorknobItem> item : Items.DOORKNOBS.values()) {
            MagicDoorknobItem doorknobItem = (MagicDoorknobItem)((Object)item.get());
            ResourceLocation texture = doorknobItem.getMainMaterial().texture();
            ResourceLocation modelLocation = doorknobTemplate.create((Item)doorknobItem, new TextureMapping().put(MAIN_TEXTURE, texture).put(TextureSlot.PARTICLE, texture), itemModels.modelOutput);
            itemModels.itemModelOutput.accept((Item)doorknobItem, (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(modelLocation, Collections.emptyList()));
        }
        TextureMapping panelTextureMapping = new TextureMapping().put(TextureSlot.PARTICLE, MagicDoorwayPartBaseBlockEntity.TEXTURE_PARTICLE.getName()).put(MAIN_TEXTURE, MagicDoorwayPartBaseBlockEntity.TEXTURE_MAIN.getName()).put(HIGHLIGHT_TEXTURE, MagicDoorwayPartBaseBlockEntity.TEXTURE_HIGHLIGHT.getName());
        Models.doorTemplate(MagicDoorwayPartBaseBlock.EnumPartType.TOP).create(doorTopModelLocation, panelTextureMapping, blockModels.modelOutput);
        Models.doorTemplate(MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM).create(doorBottomModelLocation, panelTextureMapping, blockModels.modelOutput);
        blockModels.blockStateOutput.accept(TexturedBlockModelGenerator.of((BlockModelDefinitionGenerator)MultiVariantGenerator.dispatch((Block)Blocks.MAGIC_DOOR.get(), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)doorBottomModelLocation)).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING).with((PropertyDispatch)PropertyDispatch.modify(MagicDoorBlock.PART).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM), (Object)BlockModelGenerators.NOP).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.TOP), (Object)VariantMutator.MODEL.withValue((Object)doorTopModelLocation)))));
        Models.closedDoorwayTemplate(MagicDoorwayPartBaseBlock.EnumPartType.TOP).create(doorwayClosedTopModelLocation, panelTextureMapping, blockModels.modelOutput);
        Models.closedDoorwayTemplate(MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM).create(doorwayClosedBottomModelLocation, panelTextureMapping, blockModels.modelOutput);
        Models.halfOpenDoorwayTemplate(MagicDoorwayPartBaseBlock.EnumPartType.TOP).create(doorwayHalfOpenTopModelLocation, panelTextureMapping, blockModels.modelOutput);
        Models.halfOpenDoorwayTemplate(MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM).create(doorwayHalfOpenBottomModelLocation, panelTextureMapping, blockModels.modelOutput);
        Models.openDoorwayTemplate(MagicDoorwayPartBaseBlock.EnumPartType.TOP).create(doorwayOpenTopModelLocation, panelTextureMapping, blockModels.modelOutput);
        Models.openDoorwayTemplate(MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM).create(doorwayOpenBottomModelLocation, panelTextureMapping, blockModels.modelOutput);
        blockModels.blockStateOutput.accept(TexturedBlockModelGenerator.of((BlockModelDefinitionGenerator)MultiVariantGenerator.dispatch((Block)Blocks.MAGIC_DOORWAY.get(), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)doorwayClosedBottomModelLocation)).with((PropertyDispatch)PropertyDispatch.modify(MagicDoorwayBlock.PART, (Property)MagicDoorwayBlock.OPEN_NORTH_SOUTH, (Property)MagicDoorwayBlock.OPEN_EAST_WEST).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM), (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), (Object)BlockModelGenerators.NOP).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.TOP), (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), (Object)VariantMutator.MODEL.withValue((Object)doorwayClosedTopModelLocation)).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM), (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), (Object)VariantMutator.MODEL.withValue((Object)doorwayHalfOpenBottomModelLocation)).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.TOP), (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), (Object)VariantMutator.MODEL.withValue((Object)doorwayHalfOpenTopModelLocation)).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM), (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), (Object)VariantMutator.MODEL.withValue((Object)doorwayHalfOpenBottomModelLocation).then(BlockModelGenerators.Y_ROT_90)).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.TOP), (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), (Object)VariantMutator.MODEL.withValue((Object)doorwayHalfOpenTopModelLocation).then(BlockModelGenerators.Y_ROT_90)).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM), (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), (Object)VariantMutator.MODEL.withValue((Object)doorwayOpenBottomModelLocation)).select((Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.TOP), (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), (Object)VariantMutator.MODEL.withValue((Object)doorwayOpenTopModelLocation)))));
    }
}

