/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.items;

import com.google.common.collect.Maps;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class Items {
    public static final Map<String, DeferredItem<MagicDoorknobItem>> DOORKNOBS = Maps.newLinkedHashMap();
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"magic_doorknob");

    private Items() {
    }

    private static void addDoorknob(String typeName, ToolMaterial toolMaterial, ResourceLocation mainTexture, Supplier<TagKey<Item>> ingredients) {
        DeferredItem item = ITEMS.registerItem(String.format("magic_doorknob_%s", typeName), properties -> new MagicDoorknobItem((Item.Properties)properties, typeName, toolMaterial, mainTexture, ingredients));
        DOORKNOBS.put(typeName, (DeferredItem<MagicDoorknobItem>)item);
    }

    private static void addDoorknob(String typeName, ToolMaterial toolMaterial, String blockName) {
        Items.addDoorknob(typeName, toolMaterial, ResourceLocation.withDefaultNamespace((String)String.format("block/%s", blockName)), () -> ((ToolMaterial)toolMaterial).repairItems());
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
        eventBus.addListener(Items::registerCreativeTabs);
    }

    private static void registerCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (CreativeModeTabs.TOOLS_AND_UTILITIES.equals(event.getTabKey())) {
            DOORKNOBS.values().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }

    static {
        Items.addDoorknob("wood", ToolMaterial.WOOD, "oak_planks");
        Items.addDoorknob("stone", ToolMaterial.STONE, "stone");
        Items.addDoorknob("iron", ToolMaterial.IRON, "iron_block");
        Items.addDoorknob("gold", ToolMaterial.GOLD, "gold_block");
        Items.addDoorknob("diamond", ToolMaterial.DIAMOND, "diamond_block");
        Items.addDoorknob("netherite", ToolMaterial.NETHERITE, "netherite_block");
    }
}

