/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.modeldata;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface TextureSourceReference {
    default public LookupResult lookup(SpriteGetter sprites) {
        return this.lookup(sprites, null);
    }

    default public LookupResult lookup(SpriteGetter sprites, @Nullable RandomSource randomSource) {
        return this.lookup(sprites, Direction.NORTH, randomSource);
    }

    public LookupResult lookup(SpriteGetter var1, Direction var2, @Nullable RandomSource var3);

    public record LookupResult(TextureAtlasSprite sprite, @Nullable Integer tintIndex) {
    }

    public record BlockLookup(@Nullable Level level, BlockPos pos, BlockState blockState, TextureSourceReference fallback) implements TextureSourceReference
    {
        @Override
        public LookupResult lookup(SpriteGetter sprites, Direction direction, @Nullable RandomSource randomSource) {
            Minecraft minecraft = Minecraft.getInstance();
            BlockModelShaper blockModelShaper = minecraft.getBlockRenderer().getBlockModelShaper();
            BlockStateModel blockModel = blockModelShaper.getBlockModel(this.blockState);
            ObjectArrayList parts = new ObjectArrayList();
            if (randomSource == null) {
                randomSource = RandomSource.create();
            }
            if (this.level == null) {
                blockModel.collectParts(randomSource, (List)parts);
            } else {
                blockModel.collectParts((BlockAndTintGetter)this.level, this.pos, this.blockState, randomSource, (List)parts);
            }
            LookupResult result = null;
            for (BlockModelPart part : parts) {
                Iterator iterator = part.getQuads(direction).iterator();
                if (iterator.hasNext()) {
                    BakedQuad quad = (BakedQuad)iterator.next();
                    return new LookupResult(quad.sprite(), quad.tintIndex());
                }
                for (BakedQuad quad : part.getQuads(null)) {
                    Direction quadDirection = quad.direction();
                    if (quadDirection.getAxis().isVertical() != direction.getAxis().isVertical()) continue;
                    result = new LookupResult(quad.sprite(), quad.tintIndex());
                    if (quadDirection != direction) continue;
                    return result;
                }
            }
            if (result == null) {
                return this.fallback.lookup(sprites, direction, randomSource);
            }
            return result;
        }
    }

    public record BlockParticle(@Nullable Level level, BlockPos pos, BlockState blockState, TextureSourceReference fallback) implements TextureSourceReference
    {
        @Override
        public LookupResult lookup(SpriteGetter sprites, Direction direction, @Nullable RandomSource randomSource) {
            TextureAtlasSprite icon;
            Minecraft minecraft = Minecraft.getInstance();
            BlockModelShaper blockModelShaper = minecraft.getBlockRenderer().getBlockModelShaper();
            BlockStateModel blockModel = blockModelShaper.getBlockModel(this.blockState);
            TextureAtlasSprite textureAtlasSprite = icon = this.level == null ? blockModel.particleIcon() : blockModel.particleIcon((BlockAndTintGetter)this.level, this.pos, this.blockState);
            if (icon == minecraft.getAtlasManager().getAtlasOrThrow(icon.atlasLocation()).getSprite(MissingTextureAtlasSprite.getLocation())) {
                return this.fallback.lookup(sprites, direction, randomSource);
            }
            return new LookupResult(icon, null);
        }
    }

    public record MaterialTextureSource(Material material) implements TextureSourceReference
    {
        @Override
        public LookupResult lookup(SpriteGetter sprites, Direction direction, @Nullable RandomSource randomSource) {
            return new LookupResult(sprites.get(this.material, () -> "TextureReference"), null);
        }
    }
}

