/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.advancements.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.cibernet.alchemancy.crafting.AbstractForgeRecipe;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.common.util.TriState;

public record ForgeRecipePredicate(Optional<List<Holder<Property>>> outputProperties, Optional<ItemPredicate> outputItem, Optional<ResourceLocation> recipeKey, Optional<ResourceLocation> recipeType) {
    public static final Codec<ForgeRecipePredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Property.LIST_CODEC.optionalFieldOf("properties").forGetter(ForgeRecipePredicate::outputProperties), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(ForgeRecipePredicate::outputItem), (App)ResourceLocation.CODEC.optionalFieldOf("recipe_id").forGetter(ForgeRecipePredicate::recipeKey), (App)ResourceLocation.CODEC.optionalFieldOf("recipe_type").forGetter(ForgeRecipePredicate::recipeType)).apply((Applicative)instance, ForgeRecipePredicate::new));

    public boolean matches(RecipeHolder<AbstractForgeRecipe<?>> recipe, ForgeRecipeGrid grid) {
        Object RESULT;
        if (this.outputItem().isPresent() && (RESULT = ((AbstractForgeRecipe)recipe.value()).getResult()) instanceof ItemStack) {
            ItemStack recipeResult = (ItemStack)RESULT;
            return this.outputItem.get().test(recipeResult);
        }
        if (this.recipeKey.isPresent() && recipe.id().equals((Object)this.recipeKey.get())) {
            return true;
        }
        ResourceLocation type = BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)((AbstractForgeRecipe)recipe.value()).getSerializer());
        TriState matches = ((AbstractForgeRecipe)recipe.value()).matches(this, grid);
        return this.recipeType.map(resourceLocation -> matches != TriState.FALSE && resourceLocation.equals((Object)type)).orElseGet(() -> matches == TriState.TRUE);
    }
}

