/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.advancements.criterion.DiscoverPropertyTrigger;
import net.cibernet.alchemancy.advancements.criterion.PerformForgeRecipeTrigger;
import net.cibernet.alchemancy.blocks.blockentities.AlchemancyCatalystBlockEntity;
import net.cibernet.alchemancy.blocks.blockentities.ItemStackHolderBlockEntity;
import net.cibernet.alchemancy.crafting.AbstractForgeRecipe;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.network.S2CDiscoverCodexIngredientsPayload;
import net.cibernet.alchemancy.network.S2CUnlockCodexEntriesPayload;
import net.cibernet.alchemancy.properties.TintedProperty;
import net.cibernet.alchemancy.registries.AlchemancyBlockEntities;
import net.cibernet.alchemancy.registries.AlchemancyBlocks;
import net.cibernet.alchemancy.registries.AlchemancyCriteriaTriggers;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyRecipeTypes;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AlchemancyCatalystBlock
extends TransparentBlock
implements EntityBlock {
    private static RecipeManager.CachedCheck<ForgeRecipeGrid, AbstractForgeRecipe<?>> RECIPE_CHECK;
    private static final MapCodec<AlchemancyCatalystBlock> CODEC;
    public static final BooleanProperty POWERED;

    public AlchemancyCatalystBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            AlchemancyCatalystBlock.performRecipe(player, level, pos);
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean isDye = stack.getItem() instanceof DyeItem;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AlchemancyCatalystBlockEntity) {
            AlchemancyCatalystBlockEntity catalyst = (AlchemancyCatalystBlockEntity)blockEntity;
            if (isDye || stack.is(AlchemancyItems.CHROMA_LENS)) {
                boolean muffled;
                Item item;
                int[] tint = this.getTint(stack);
                boolean success = false;
                if (tint.length == 0) {
                    tint = null;
                }
                if ((item = stack.getItem()) instanceof DyeItem) {
                    DyeItem dye = (DyeItem)item;
                    if (!catalyst.getCrystalTexture().equals(dye.getDyeColor().getName())) {
                        catalyst.setCrystalTexture(dye.getDyeColor());
                        success = true;
                    }
                }
                if (!Arrays.equals(catalyst.getTintColors(), tint)) {
                    catalyst.setTint(tint);
                    success = true;
                }
                if ((muffled = InfusedPropertiesHelper.hasInfusedProperty(stack, AlchemancyProperties.MUFFLED)) != catalyst.silent) {
                    catalyst.silent = muffled;
                    success = true;
                }
                if (success) {
                    if (isDye) {
                        stack.consume(1, (LivingEntity)player);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private int[] getTint(ItemStack stack) {
        int[] nArray;
        int alpha = FastColor.ARGB32.alpha((int)CommonUtils.getPropertyDrivenTint(stack));
        int[] tintedColors = Arrays.stream((Integer[])((TintedProperty)AlchemancyProperties.TINTED.get()).getData(stack)).mapToInt(c -> FastColor.ARGB32.color((int)alpha, (int)c)).toArray();
        if (tintedColors.length == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = FastColor.ARGB32.color((int)alpha, (int)0xFFFFFF);
        } else {
            nArray = tintedColors;
        }
        return nArray;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean neighborPowered = level.hasNeighborSignal(pos);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (neighborPowered && !powered) {
            level.scheduleTick(pos, (Block)this, 4);
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.TRUE), 2);
            AlchemancyCatalystBlock.performRecipe(null, level, pos);
        } else if (!neighborPowered && powered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.FALSE), 2);
        }
    }

    public static void performRecipe(@Nullable Player player, Level level, BlockPos catalystPos) {
        BlockEntity blockEntity;
        BlockPos forgePos;
        if (RECIPE_CHECK == null) {
            RECIPE_CHECK = AlchemancyCatalystBlock.createCheck((RecipeType)AlchemancyRecipeTypes.ALCHEMANCY_FORGE.get());
        }
        if (level.getBlockState(forgePos = catalystPos.below(2)).is(AlchemancyBlocks.ALCHEMANCY_FORGE) && (blockEntity = level.getBlockEntity(forgePos)) instanceof ItemStackHolderBlockEntity) {
            ItemStackHolderBlockEntity forge = (ItemStackHolderBlockEntity)blockEntity;
            ForgeRecipeGrid grid = new ForgeRecipeGrid(level, forgePos, forge);
            List<ResourceLocation> itemsToDiscover = grid.getItemPedestals().stream().filter(pedestal -> !pedestal.isEmpty()).map(pedestal -> BuiltInRegistries.ITEM.getKey((Object)pedestal.getItem().getItem())).toList();
            AtomicBoolean loop = new AtomicBoolean(true);
            for (int i = 0; i < 128 && loop.get() && !grid.isPerformingTransmutation(); ++i) {
                RECIPE_CHECK.getRecipeFor((RecipeInput)grid, level).ifPresentOrElse(recipe -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ((PerformForgeRecipeTrigger)((Object)((Object)AlchemancyCriteriaTriggers.PERFORM_FORGE_RECIPE.get()))).trigger(serverPlayer, (RecipeHolder<AbstractForgeRecipe<?>>)recipe, grid);
                    }
                    grid.processRecipe((AbstractForgeRecipe)recipe.value(), level.registryAccess());
                }, () -> loop.set(false));
            }
            ItemStack output = grid.getCurrentOutput();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new S2CUnlockCodexEntriesPayload(output), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (!itemsToDiscover.isEmpty()) {
                    ((DiscoverPropertyTrigger)((Object)AlchemancyCriteriaTriggers.DISCOVER_PROPERTY.get())).trigger(serverPlayer, output);
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new S2CDiscoverCodexIngredientsPayload(itemsToDiscover), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (grid.shouldConsumeWarped()) {
                InfusedPropertiesHelper.removeProperty(output, AlchemancyProperties.WARPED);
            }
            forge.removeItem(1);
            InfusedPropertiesHelper.truncateProperties(output);
            grid.applyGlint.ifPresent(aBoolean -> output.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, aBoolean));
            ItemStackHolderBlockEntity.dropItem(level, forgePos, output);
            BlockEntity blockEntity2 = level.getBlockEntity(catalystPos);
            if (blockEntity2 instanceof AlchemancyCatalystBlockEntity) {
                AlchemancyCatalystBlockEntity catalyst = (AlchemancyCatalystBlockEntity)blockEntity2;
                catalyst.playAnimation(false);
                level.gameEvent((Holder)GameEvent.BLOCK_ACTIVATE, catalystPos, new GameEvent.Context((Entity)player, level.getBlockState(catalystPos)));
            }
        }
    }

    public static RecipeManager.CachedCheck<ForgeRecipeGrid, AbstractForgeRecipe<?>> createCheck(RecipeType<AbstractForgeRecipe<?>> recipeType) {
        return (input, level) -> level.getRecipeManager().getRecipesFor(recipeType, input, level).stream().filter(recipe -> ((AbstractForgeRecipe)recipe.value()).matches((ForgeRecipeGrid)input, level)).min(Comparator.comparingInt(recipe -> ((AbstractForgeRecipe)recipe.value()).getRecipeCompareValue((ForgeRecipeGrid)input)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AlchemancyCatalystBlockEntity(pos, state);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AlchemancyCatalystBlockEntity) {
            AlchemancyCatalystBlockEntity catalyst = (AlchemancyCatalystBlockEntity)blockEntity;
            catalyst.randomizeSpinOffset(level.random);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return AlchemancyCatalystBlock.createTicker(level, blockEntityType);
    }

    @javax.annotation.Nullable
    protected static <T extends AlchemancyCatalystBlockEntity> BlockEntityTicker<AlchemancyCatalystBlockEntity> createTicker(Level level, BlockEntityType<? extends BlockEntity> serverType) {
        return serverType != AlchemancyBlockEntities.ALCHEMANCY_CATALYST.get() ? null : (level.isClientSide ? AlchemancyCatalystBlockEntity::clientTick : AlchemancyCatalystBlockEntity::serverTick);
    }

    static {
        CODEC = AlchemancyCatalystBlock.simpleCodec(AlchemancyCatalystBlock::new);
        POWERED = BlockStateProperties.POWERED;
    }
}

