/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.blocks;

import net.cibernet.alchemancy.advancements.criterion.ActivateForgeTrigger;
import net.cibernet.alchemancy.blocks.AlchemancyCatalystBlock;
import net.cibernet.alchemancy.blocks.InfusionPedestalBlock;
import net.cibernet.alchemancy.blocks.blockentities.AlchemancyCatalystBlockEntity;
import net.cibernet.alchemancy.registries.AlchemancyBlocks;
import net.cibernet.alchemancy.registries.AlchemancyCriteriaTriggers;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AlchemancyForgeBlock
extends InfusionPedestalBlock {
    private static final VoxelShape SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9375, (double)1.0);

    public AlchemancyForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item;
        BlockPos targetPos = pos.above(2);
        if (level.getBlockState(targetPos).is(AlchemancyTags.Blocks.ALCHEMANCY_CRYSTAL_CATALYSTS)) {
            BlockEntity blockEntity;
            level.destroyBlock(targetPos, false);
            level.setBlockAndUpdate(targetPos, ((AlchemancyCatalystBlock)((Object)AlchemancyBlocks.ALCHEMANCY_CATALYST.get())).defaultBlockState());
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(targetPos)) instanceof AlchemancyCatalystBlockEntity) {
                AlchemancyCatalystBlockEntity catalyst = (AlchemancyCatalystBlockEntity)blockEntity;
                catalyst.playAnimation(true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((ActivateForgeTrigger)((Object)AlchemancyCriteriaTriggers.ACTIVATE_FORGE.get())).trigger(serverPlayer, pos);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (hitResult.getDirection() == Direction.UP && level.getBlockState(pos.above(2)).canBeReplaced() && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if ((stack.is(AlchemancyItems.ALCHEMANCY_CATALYST) || blockItem.getBlock().defaultBlockState().is(AlchemancyTags.Blocks.ALCHEMANCY_CRYSTAL_CATALYSTS)) && blockItem.place(new BlockPlaceContext(level, player, hand, stack, new BlockHitResult(hitResult.getLocation(), hitResult.getDirection(), pos.above(2), hitResult.isInside()))).consumesAction()) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

