/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.blocks;

import com.mojang.serialization.MapCodec;
import java.util.TreeMap;
import net.cibernet.alchemancy.events.handler.GeneralEventHandler;
import net.cibernet.alchemancy.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class FlatHopperBlock
extends DirectionalBlock {
    private static final TreeMap<Direction, VoxelShape> SHAPES = VoxelShapeUtils.createDirectionMap(Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)3.0), Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0, (double)16.0)}));
    public static final MapCodec<FlatHopperBlock> CODEC = FlatHopperBlock.simpleCodec(FlatHopperBlock::new);

    public FlatHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        GeneralEventHandler.registerTickingBlockFunction((Block)this, FlatHopperBlock::tick);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public static void tick(ServerLevel level, BlockPos pos) {
        BlockState connectedState;
        Direction facing = ((Direction)level.getBlockState(pos).getValue((Property)FACING)).getOpposite();
        BlockPos connectedPos = pos.relative(facing);
        IItemHandler cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, connectedPos, connectedState = level.getBlockState(connectedPos), level.getBlockEntity(pos), (Object)facing.getOpposite());
        if (cap == null) {
            return;
        }
        for (ItemEntity item : level.getEntitiesOfClass(ItemEntity.class, new AABB(pos))) {
            if (item.hasPickUpDelay() && !item.getPersistentData().getBoolean("alchemancy:from_pedestal") || item.getPersistentData().getBoolean("alchemancy:from_pedestal_click")) continue;
            if (ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)item.getItem(), (boolean)false).isEmpty()) {
                item.discard();
            }
            return;
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

