/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.blocks;

import net.cibernet.alchemancy.properties.GlowRingProperty;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlowingOrbBlock
extends BarrierBlock {
    private static final VoxelShape SHAPE = Shapes.box((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);

    public GlowingOrbBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        Vec3 center = pos.getCenter();
        RandomSource random = level.getRandom();
        for (int i = 0; i < 8; ++i) {
            level.addParticle(GlowRingProperty.PARTICLES, center.x() + (double)((random.nextFloat() - 0.5f) * 0.3f), center.y() + (double)((random.nextFloat() - 0.5f) * 0.3f), center.z() + (double)((random.nextFloat() - 0.5f) * 0.3f), (double)((random.nextFloat() - 0.5f) * 0.6f), (double)((random.nextFloat() - 0.5f) * 0.3f), (double)((random.nextFloat() - 0.5f) * 0.6f));
        }
        level.playLocalSound(pos, (SoundEvent)AlchemancySoundEvents.GLOWING_ORB_EXTINGUISH.value(), SoundSource.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Vec3 center = pos.getCenter();
        level.addParticle(GlowRingProperty.PARTICLES, center.x + (double)((random.nextFloat() - 0.5f) * 0.5f), center.y + (double)((random.nextFloat() - 0.5f) * 0.5f), center.z + (double)((random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.0, 0.0);
    }
}

