/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.blocks;

import com.mojang.serialization.MapCodec;
import java.util.TreeMap;
import net.cibernet.alchemancy.events.handler.GeneralEventHandler;
import net.cibernet.alchemancy.network.S2CAddPlayerMovementPayload;
import net.cibernet.alchemancy.network.S2CPlayGustBasketEffectsPayload;
import net.cibernet.alchemancy.properties.special.GustJetProperty;
import net.cibernet.alchemancy.registries.AlchemancyBlocks;
import net.cibernet.alchemancy.registries.AlchemancySoundEvents;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.CommonUtils;
import net.cibernet.alchemancy.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT})
public class GustBasketBlock
extends DirectionalBlock {
    public static final MapCodec<GustBasketBlock> CODEC = GustBasketBlock.simpleCodec(GustBasketBlock::new);
    private static final float DISTANCE = 6.0f;
    private static final TreeMap<Direction, VoxelShape> SHAPES = VoxelShapeUtils.createDirectionMap(Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)}));
    private static int gustSounds = 0;

    public GustBasketBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
        GeneralEventHandler.registerTickingBlockFunction((Block)this, GustBasketBlock::tick);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        int amount = random.nextInt(5);
        for (int i = 0; i < amount; ++i) {
            double xOff = facing.getStepX() < 0 ? 0.0 : random.nextDouble() * (double)(1 - facing.getStepX());
            double yOff = facing.getStepY() < 0 ? 0.0 : random.nextDouble() * (double)(1 - facing.getStepY());
            double zOff = facing.getStepZ() < 0 ? 0.0 : random.nextDouble() * (double)(1 - facing.getStepZ());
            level.addParticle((ParticleOptions)ParticleTypes.SMALL_GUST, (double)pos.getX() + xOff + (double)Math.max(0, facing.getStepX()), (double)pos.getY() + yOff + (double)Math.max(0, facing.getStepY()), (double)pos.getZ() + zOff + (double)Math.max(0, facing.getStepZ()), 0.0, 0.0, 0.0);
        }
    }

    public static void tick(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Direction facing = (Direction)state.getValue((Property)FACING);
        Vec3 facingStep = new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ());
        Vec3 offset = facingStep.scale(0.5);
        Vec3 startVec = pos.getCenter().add(offset.x(), offset.y(), offset.z());
        BlockPos clipPos = level.clip(new ClipContext(startVec, startVec.add(facingStep.scale(6.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty())).getBlockPos();
        double distance = pos.distSqr((Vec3i)clipPos);
        if (distance <= 0.0) {
            return;
        }
        distance = Math.min(6.0, Math.sqrt(distance));
        boolean playEffects = false;
        for (Entity target : level.getEntities((Entity)null, new AABB(pos).expandTowards(facingStep.scale(distance - 1.0)), EntitySelector.NO_SPECTATORS.and(entity -> !entity.getType().is(AlchemancyTags.EntityTypes.UNMOVABLE)))) {
            playEffects = true;
            Vec3 movement = facingStep.scale((1.0 - target.position().distanceTo(pos.getCenter()) / 6.0) * 0.25);
            if (facing != Direction.UP && target instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)target;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2CAddPlayerMovementPayload(movement), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            target.setDeltaMovement(target.getDeltaMovement().add(movement));
            target.hasImpulse = true;
            target.fallDistance = Math.max(0.0f, target.fallDistance - 2.0f);
        }
        if (playEffects) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)level.getChunk(pos).getPos(), (CustomPacketPayload)new S2CPlayGustBasketEffectsPayload(pos, distance), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void clientPlayerTick(Player player) {
        if (player.isSpectator() || player.getType().is(AlchemancyTags.EntityTypes.UNMOVABLE)) {
            return;
        }
        Level level = player.level();
        BlockPos.betweenClosedStream((AABB)CommonUtils.boundingBoxAroundPoint(player.position(), player.getBbWidth() * 0.45f).expandTowards(0.0, -6.0, 0.0)).forEach(pos -> {
            BlockState state = level.getBlockState(pos);
            if (!state.is(AlchemancyBlocks.GUST_BASKET) || state.getValue((Property)FACING) != Direction.UP) {
                return;
            }
            Direction facing = Direction.UP;
            Vec3 facingStep = new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ());
            Vec3 offset = facingStep.scale(0.5);
            Vec3 startVec = pos.getCenter().add(offset.x(), offset.y(), offset.z());
            BlockPos clipPos = level.clip(new ClipContext(startVec, startVec.add(facingStep.scale(6.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty())).getBlockPos();
            float distance = Mth.sqrt((float)((float)pos.distSqr((Vec3i)clipPos)));
            if ((double)((float)pos.getY() + distance) < player.getY()) {
                return;
            }
            Vec3 movement = facingStep.scale((1.0 - player.position().distanceTo(pos.getCenter()) / 6.0) * 0.25);
            player.setDeltaMovement(player.getDeltaMovement().add(movement));
            player.hasImpulse = true;
        });
    }

    @SubscribeEvent
    private static void resetGustSounds(ClientTickEvent.Post event) {
        gustSounds = 0;
    }

    public static void playGustEffects(Level level, BlockPos pos, double distance) {
        RandomSource random = level.getRandom();
        Direction facing = (Direction)level.getBlockState(pos).getValue((Property)FACING);
        double speed = 0.33f;
        int amount = random.nextInt(5);
        for (int i = 0; i < amount; ++i) {
            double xOff = facing.getStepX() < 0 ? 0.0 : random.nextDouble() * (double)(1 - facing.getStepX());
            double yOff = facing.getStepY() < 0 ? 0.0 : random.nextDouble() * (double)(1 - facing.getStepY());
            double zOff = facing.getStepZ() < 0 ? 0.0 : random.nextDouble() * (double)(1 - facing.getStepZ());
            level.addParticle(GustJetProperty.PARTICLES, (double)pos.getX() + xOff + (double)Math.max(0, facing.getStepX()), (double)pos.getY() + yOff + (double)Math.max(0, facing.getStepY()), (double)pos.getZ() + zOff + (double)Math.max(0, facing.getStepZ()), (double)facing.getStepX() * speed, (double)facing.getStepY() * speed, (double)facing.getStepZ() * speed);
        }
        if (random.nextFloat() < 0.15f && gustSounds <= 2) {
            level.playLocalSound(pos, (SoundEvent)AlchemancySoundEvents.GUST_BASKET.value(), SoundSource.BLOCKS, 0.25f, (float)(distance / 6.0), false);
            ++gustSounds;
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

