/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.registries.DeferredBlock;

public class PottedBlazebloomBlock
extends FlowerPotBlock {
    private static final AABB PARTICLE_AREA = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0).bounds();

    public PottedBlazebloomBlock(DeferredBlock<? extends FlowerBlock> flower, BlockBehaviour.Properties properties) {
        super(() -> (FlowerPotBlock)Blocks.FLOWER_POT, flower, properties);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(flower.getId(), () -> this);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        AABB shape = PARTICLE_AREA.move(0.0, this.getShape((BlockState)state, (BlockGetter)level, (BlockPos)pos, (CollisionContext)CollisionContext.empty()).bounds().maxY, 0.0);
        double d0 = (double)pos.getX() + shape.minX;
        double d1 = (double)pos.getY() + shape.minY;
        double d2 = (double)pos.getZ() + shape.minZ;
        double d5 = random.nextDouble() * shape.getXsize();
        double d6 = random.nextDouble() * shape.getYsize();
        double d7 = random.nextDouble() * shape.getZsize();
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
    }
}

