/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.client.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.PropertyFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CodexEntryReloadListenener
implements ResourceManagerReloadListener {
    private static final Gson GSON_INSTANCE = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final HashMap<Holder<Property>, CodexEntry> ENTRIES = new HashMap();
    public static final CodexEntryReloadListenener INSTANCE = new CodexEntryReloadListenener();
    public static final String PATH = "alchemancy/codex_entries";

    public void onResourceManagerReload(ResourceManager resourceManager) {
        ENTRIES.clear();
        resourceManager.listResources(PATH, r -> r.getPath().endsWith(".json")).forEach((location, resource) -> {
            Optional propertyHolder = ((Registry)AlchemancyProperties.REGISTRY.getRegistry().get()).getHolder(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)location.getPath().substring(PATH.length() + 1, location.getPath().lastIndexOf(".json"))));
            if (propertyHolder.isEmpty()) {
                return;
            }
            try {
                InputStream inputStream = resource.open();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                JsonObject json = ((JsonElement)GsonHelper.fromJson((Gson)GSON_INSTANCE, (Reader)reader, JsonElement.class)).getAsJsonObject();
                ENTRIES.put((Holder<Property>)((Holder)propertyHolder.get()), (CodexEntry)((Pair)CodexEntry.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getPartialOrThrow()).getFirst());
            }
            catch (IOException | IndexOutOfBoundsException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static HashMap<Holder<Property>, CodexEntry> getEntries() {
        return ENTRIES;
    }

    public record CodexEntry(Component flavor, List<PropertyFunction> functions, List<Holder<Item>> innates) {
        public static final Codec<CodexEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.optionalFieldOf("flavor", (Object)Component.empty()).forGetter(CodexEntry::flavor), (App)PropertyFunction.CODEC.listOf().fieldOf("functions").forGetter(CodexEntry::functions), (App)ItemStack.ITEM_NON_AIR_CODEC.listOf().optionalFieldOf("innate", List.of()).forGetter(CodexEntry::innates)).apply((Applicative)instance, CodexEntry::new));
    }
}

