/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.client.particle;

import net.cibernet.alchemancy.client.particle.options.SparkParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DustParticleBase;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ScalableParticleOptionsBase;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SparkParticle
extends DustParticleBase<SparkParticleOptions> {
    protected SparkParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SparkParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, (ScalableParticleOptionsBase)options, sprites);
        float f = (float)Math.random() * 0.4f - 0.2f;
        this.rCol = Math.clamp(options.getColor().x() + f, 0.0f, 1.0f);
        this.gCol = Math.clamp(options.getColor().y() + f, 0.0f, 1.0f);
        this.bCol = Math.clamp(options.getColor().z() + f, 0.0f, 1.0f);
        if (!options.stationary) {
            this.setParticleSpeed(xSpeed, ySpeed, zSpeed);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SparkParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SparkParticleOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprites);
        }
    }
}

