/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.cibernet.alchemancy.blocks.blockentities.AlchemancyCatalystBlockEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AlchemancyCatalystRenderer
implements BlockEntityRenderer<AlchemancyCatalystBlockEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"alchemancy_catalyst"), "main");
    public static final ResourceLocation FRAME_TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"textures/entity/alchemancy_catalyst/alchemancy_catalyst_frame.png");
    private final ModelPart outer;
    private final ModelPart inner;

    public AlchemancyCatalystRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.outer = root.getChild("outer");
        this.inner = this.outer.getChild("inner");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition outer = partdefinition.addOrReplaceChild("outer", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -14.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)22.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition inner = outer.addOrReplaceChild("inner", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        inner.addOrReplaceChild("crystal", CubeListBuilder.create().texOffs(0, 32).addBox(-6.0f, -6.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)-0.6109f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(AlchemancyCatalystBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float scale = 1.0f;
        poseStack.translate(0.5, -0.5 * (double)scale, 0.5);
        poseStack.scale(scale, scale, scale);
        float animationProgress = blockEntity.getAnimationProgressLeft(partialTick);
        if (animationProgress > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(-0.5, 0.0, -0.5);
            BeaconRenderer.renderBeaconBeam((PoseStack)poseStack, (MultiBufferSource)bufferSource, (ResourceLocation)BeaconRenderer.BEAM_LOCATION, (float)partialTick, (float)1.0f, (long)blockEntity.getLevel().getGameTime(), (int)-1, (int)2, (int)blockEntity.getTint(), (float)(0.2f * animationProgress), (float)(0.25f * animationProgress));
            poseStack.popPose();
        }
        float time = blockEntity.getSpinOffset() + blockEntity.getRotationTime(partialTick);
        this.inner.yRot = time % 360.0f;
        this.inner.y = (Mth.lerp((float)(Math.max(0.0f, animationProgress - 0.5f) * 2.0f), (float)(Mth.sin((float)(time * 1.5f)) * 2.0f), (float)0.0f) - Math.max(0.0f, animationProgress - 0.5f) * 8.0f) / scale;
        this.outer.render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)("textures/entity/alchemancy_catalyst/" + blockEntity.getCrystalTexture() + ".png")))), 0xF000F0, packedOverlay, blockEntity.getTint());
    }
}

