/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.cibernet.alchemancy.blocks.InfusionPedestalBlock;
import net.cibernet.alchemancy.blocks.blockentities.ItemStackHolderBlockEntity;
import net.cibernet.alchemancy.client.render.ItemStackHolderCustomRender;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemStackHolderRenderer
implements BlockEntityRenderer<ItemStackHolderBlockEntity> {
    private final ItemRenderer itemRenderer;
    protected final EntityRenderDispatcher entityRenderDispatcher;

    public ItemStackHolderRenderer(BlockEntityRendererProvider.Context pContext) {
        this.itemRenderer = pContext.getItemRenderer();
        this.entityRenderDispatcher = pContext.getEntityRenderer();
    }

    public void render(ItemStackHolderBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        Block block = blockEntity.getBlockState().getBlock();
        if (block instanceof ItemStackHolderCustomRender) {
            ItemStackHolderCustomRender block2 = (ItemStackHolderCustomRender)block;
            block2.render(this.itemRenderer, blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        } else {
            Level level = blockEntity.getLevel();
            BlockPos itemLightPos = blockEntity.getBlockPos().above();
            double height = blockEntity.getBlockState().getShape((BlockGetter)level, (BlockPos)blockEntity.getBlockPos()).bounds().maxY;
            poseStack.translate(0.5, height + (double)0.2f, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(((Direction)blockEntity.getBlockState().getValue((Property)InfusionPedestalBlock.FACING)).toYRot()));
            this.itemRenderer.renderStatic(blockEntity.getItem(), ItemDisplayContext.GROUND, LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, itemLightPos), (int)level.getBrightness(LightLayer.SKY, itemLightPos)), OverlayTexture.NO_OVERLAY, poseStack, bufferSource, level, 0);
        }
        poseStack.popPose();
    }
}

