/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Arrays;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.network.C2SChromatizePayload;
import net.cibernet.alchemancy.network.C2SResetItemTintPayload;
import net.cibernet.alchemancy.properties.TintedProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.ColorUtils;
import net.cibernet.alchemancy.util.CommonUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ChromaTintingScreen
extends Screen {
    private final ItemStack affectedItem;
    private final Integer[] originalTint;
    private HeaderAndFooterLayout layout;
    private ColorSlider hueSlider;
    private ColorSlider saturationSlider;
    private ColorSlider brightnessSlider;
    private EditBox hexInput = null;
    private static final ResourceLocation HUE_SLIDER_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"chromatize/slider_hue");
    private static final ResourceLocation SATURATION_SLIDER_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"chromatize/slider_saturation");
    private static final ResourceLocation BRIGHTNESS_SLIDER_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"chromatize/slider_brightness");
    private static final ResourceLocation INWORLD_MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/inworld_menu_list_background.png");
    private static final int MAX_HUE = 720;
    private static final int MAX_SB = 200;

    public ChromaTintingScreen(ItemStack stack) {
        super((Component)Component.translatable((String)"screen.chromachine.title"));
        this.affectedItem = stack;
        this.originalTint = (Integer[])((TintedProperty)AlchemancyProperties.TINTED.value()).getData(stack);
    }

    protected void init() {
        super.init();
        this.layout = new HeaderAndFooterLayout((Screen)this, 32, 32);
        LinearLayout footer = ((LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal())).spacing(5);
        footer.defaultCellSetting().alignHorizontallyCenter();
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, p_329727_ -> {
            if (this.originalTint == null || this.originalTint.length == 0) {
                InfusedPropertiesHelper.removeProperty(this.affectedItem, AlchemancyProperties.TINTED);
            } else {
                ((TintedProperty)AlchemancyProperties.TINTED.value()).setData(this.affectedItem, this.originalTint);
            }
            this.onClose();
        }).width(100).build());
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, p_329727_ -> {
            if (InfusedPropertiesHelper.hasProperty(this.affectedItem, AlchemancyProperties.TINTED)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new C2SChromatizePayload(this.getColor()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.onClose();
        }).width(100).build());
        LinearLayout header = ((LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical())).spacing(5);
        header.addChild((LayoutElement)new StringWidget(this.width, 16, this.getTitle(), this.font).alignCenter());
        LinearLayout body = LinearLayout.vertical().spacing(10);
        this.layout.addToContents((LayoutElement)body);
        Integer[] colors = (Integer[])((TintedProperty)AlchemancyProperties.TINTED.get()).getData(this.affectedItem);
        int color = colors.length > 0 ? colors[0] : -1;
        float[] hsb = Color.RGBtoHSB(FastColor.ARGB32.red((int)color), FastColor.ARGB32.green((int)color), FastColor.ARGB32.blue((int)color), new float[3]);
        this.hueSlider = new ColorSlider(0, 0, 200, 20, 720.0, hsb[0] * 720.0f, ColorComponent.HUE, HUE_SLIDER_SPRITE);
        body.addChild((LayoutElement)this.hueSlider);
        this.saturationSlider = new ColorSlider(0, 0, 200, 20, 200.0, hsb[1] * 200.0f, ColorComponent.SATURATION, SATURATION_SLIDER_SPRITE);
        body.addChild((LayoutElement)this.saturationSlider);
        this.brightnessSlider = new ColorSlider(0, 0, 200, 20, 200.0, hsb[2] * 200.0f, ColorComponent.BRIGHTNESS, BRIGHTNESS_SLIDER_SPRITE);
        body.addChild((LayoutElement)this.brightnessSlider);
        LinearLayout bottom = LinearLayout.horizontal().spacing(20);
        LinearLayout bottomLeft = LinearLayout.vertical().spacing(10);
        body.addChild((LayoutElement)bottom);
        bottom.addChild((LayoutElement)bottomLeft);
        LinearLayout hexDiv = LinearLayout.horizontal().spacing(2);
        bottomLeft.addChild((LayoutElement)hexDiv);
        LinearLayout hexSymbol = LinearLayout.vertical();
        hexSymbol.defaultCellSetting().alignVerticallyMiddle().paddingTop(6);
        hexSymbol.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)"#"), this.font));
        hexDiv.addChild((LayoutElement)hexSymbol);
        if (this.hexInput == null) {
            this.hexInput = new EditBox(this.font, 48, 20, (Component)Component.empty()){

                public void insertText(@NotNull String textToWrite) {
                    super.insertText(textToWrite.toUpperCase().replaceAll("(?![A-F]|[0-9])[\\s\\S]", ""));
                }

                public boolean charTyped(char codePoint, int modifiers) {
                    if ((codePoint = Character.toUpperCase(codePoint)) >= 'A' && codePoint <= 'F' || codePoint >= '0' && codePoint <= '9') {
                        return super.charTyped(codePoint, modifiers);
                    }
                    return false;
                }

                public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                    if (keyCode == 257) {
                        ChromaTintingScreen.this.updateColorFromHex();
                        ChromaTintingScreen.this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                        return true;
                    }
                    return super.keyPressed(keyCode, scanCode, modifiers);
                }
            };
            this.hexInput.setMaxLength(6);
            this.hexInput.setValue(ColorUtils.colorToHexString(color).substring(2));
        }
        hexDiv.addChild((LayoutElement)this.hexInput);
        hexDiv.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"screen.chromachine.apply_hex"), p_329727_ -> this.updateColorFromHex()).width(64).build());
        bottomLeft.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"screen.chromachine.reset"), button -> {
            this.hexInput.setValue("FFFFFF");
            this.hueSlider.setValue(0.0);
            this.saturationSlider.setValue(0.0);
            this.brightnessSlider.setValue(200.0);
            PacketDistributor.sendToServer((CustomPacketPayload)new C2SResetItemTintPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            InfusedPropertiesHelper.removeProperty(this.affectedItem, AlchemancyProperties.TINTED);
        }).width(64).build());
        bottom.addChild((LayoutElement)new ItemDisplayWidget(48, this.affectedItem));
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.arrangeElements();
    }

    protected void updateColorFromHex() {
        int hexColor = FastColor.ARGB32.color((int)255, (int)(this.hexInput.getValue().isEmpty() ? 0xFFFFFF : Integer.parseInt(this.hexInput.getValue(), 16)));
        float[] hexHsb = Color.RGBtoHSB(FastColor.ARGB32.red((int)hexColor), FastColor.ARGB32.green((int)hexColor), FastColor.ARGB32.blue((int)hexColor), new float[3]);
        this.hueSlider.setValue(hexHsb[0] * 720.0f);
        this.saturationSlider.setValue(hexHsb[1] * 200.0f);
        this.brightnessSlider.setValue(hexHsb[2] * 200.0f);
        this.hexInput.setValue(ColorUtils.colorToHexString(hexColor).substring(2));
        CommonUtils.applyChromaTint(this.affectedItem, hexColor);
    }

    protected float getHue() {
        return this.hueSlider.getValueForColor();
    }

    protected float getSaturation() {
        return this.saturationSlider.getValueForColor();
    }

    protected float getBrightness() {
        return this.brightnessSlider.getValueForColor();
    }

    protected int getColor() {
        return Color.HSBtoRGB(this.getHue(), this.getSaturation(), this.getBrightness());
    }

    public void onClose() {
        super.onClose();
        if (!Arrays.equals((Object[])this.originalTint, (Object[])((TintedProperty)AlchemancyProperties.TINTED.get()).getData(this.affectedItem))) {
            PacketDistributor.sendToServer((CustomPacketPayload)new C2SChromatizePayload(this.getColor()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableBlend();
        guiGraphics.blit(Screen.INWORLD_HEADER_SEPARATOR, 0, this.layout.getHeaderHeight() - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
        guiGraphics.blit(Screen.INWORLD_FOOTER_SEPARATOR, 0, this.height - this.layout.getFooterHeight(), 0.0f, 0.0f, this.width, 2, 32, 2);
        guiGraphics.blit(INWORLD_MENU_LIST_BACKGROUND, 0, this.layout.getHeaderHeight(), (float)this.layout.getWidth(), (float)(this.layout.getHeight() - this.layout.getFooterHeight()), this.width, this.height - (this.layout.getHeaderHeight() + this.layout.getFooterHeight()), 32, 32);
        RenderSystem.disableBlend();
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public class ColorSlider
    extends ExtendedSlider {
        private static final ResourceLocation BACK_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"chromatize/slider_back");
        private static final ResourceLocation HIGHLIGHT_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"chromatize/slider_highlight");
        private static final ResourceLocation NEW_ENTRY_ICON = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"infusion_codex/new_entry_icon");
        private final ColorComponent component;
        private final ResourceLocation sliderSprite;

        public ColorSlider(int x, int y, int width, int height, double maxValue, double currentValue, ColorComponent component, ResourceLocation sliderSprite) {
            super(x, y, width, height, (Component)Component.empty(), (Component)Component.empty(), 0.0, maxValue, currentValue, false);
            this.component = component;
            this.sliderSprite = sliderSprite;
        }

        public float getValueForColor() {
            return (float)this.value;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int color = Color.HSBtoRGB(ChromaTintingScreen.this.getHue(), this.component.ordinal() > ColorComponent.SATURATION.ordinal() ? ChromaTintingScreen.this.getSaturation() : 1.0f, this.component.ordinal() > ColorComponent.BRIGHTNESS.ordinal() ? ChromaTintingScreen.this.getBrightness() : 1.0f);
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.setColor((float)FastColor.ARGB32.red((int)color) / 255.0f, (float)FastColor.ARGB32.green((int)color) / 255.0f, (float)FastColor.ARGB32.blue((int)color) / 255.0f, this.alpha);
            guiGraphics.blitSprite(BACK_SPRITE, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            guiGraphics.blitSprite(this.sliderSprite, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            if (this.isFocused()) {
                guiGraphics.blitSprite(HIGHLIGHT_SPRITE, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            guiGraphics.blitSprite(this.getHandleSprite(), this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY(), 8, this.getHeight());
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            int i = this.active ? 0xFFFFFF : 0xA0A0A0;
            this.renderScrollingString(guiGraphics, minecraft.font, 2, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }

        protected void applyValue() {
            int color = ChromaTintingScreen.this.getColor();
            CommonUtils.applyChromaTint(ChromaTintingScreen.this.affectedItem, color);
            ChromaTintingScreen.this.hexInput.setValue(ColorUtils.colorToHexString(color).substring(2));
        }
    }

    public static enum ColorComponent {
        HUE,
        SATURATION,
        BRIGHTNESS;

    }

    public class ItemDisplayWidget
    extends AbstractWidget {
        private final ItemStack stack;

        public ItemDisplayWidget(int size, ItemStack stack) {
            this(size, size, stack);
        }

        public ItemDisplayWidget(int width, int height, ItemStack stack) {
            super(0, 0, width, height, stack.getDisplayName());
            this.stack = stack;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            PoseStack poseStack = guiGraphics.pose();
            float xs = (float)this.getWidth() / 16.0f;
            float ys = (float)this.getHeight() / 16.0f;
            poseStack.pushPose();
            poseStack.scale(xs, ys, 1.0f);
            guiGraphics.renderFakeItem(this.stack, (int)((float)this.getX() / xs), (int)((float)this.getY() / ys));
            poseStack.popPose();
            if (mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight()) {
                guiGraphics.renderTooltip(ChromaTintingScreen.this.font, this.stack, mouseX, mouseY);
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

