/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.cibernet.alchemancy.client.data.CodexEntryReloadListenener;
import net.cibernet.alchemancy.data.save.InfusionCodexSaveData;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.ArcaneProperty;
import net.cibernet.alchemancy.properties.BurningProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.ShockDamageProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.CommonUtils;
import net.cibernet.alchemancy.util.PropertyFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;

public class InfusionCodexEntryScreen
extends Screen {
    private static final ResourceLocation INWORLD_MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/inworld_menu_list_background.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller_background");
    private final Holder<Property> property;
    private final CodexEntryReloadListenener.CodexEntry entry;
    private final ItemStack[] dormantItems;
    private final int undiscoveredItems;
    private final boolean unobtainable;
    protected final Screen lastScreen;
    private HeaderAndFooterLayout layout;

    protected InfusionCodexEntryScreen(Holder<Property> property, CodexEntryReloadListenener.CodexEntry entry, Screen lastScreen) {
        super(((Property)property.value()).getName());
        this.property = property;
        this.entry = entry;
        this.lastScreen = lastScreen;
        AtomicInteger undiscovered = new AtomicInteger();
        Ingredient ingredient = Ingredient.of(((Property)property.value()).getDormantPropertyTag());
        this.dormantItems = ingredient.isEmpty() ? new ItemStack[]{} : (ItemStack[])Arrays.stream(ingredient.getItems()).filter(stack -> !stack.is(Items.BARRIER)).filter(stack -> {
            if (InfusionCodexSaveData.isItemDiscovered(stack)) {
                return true;
            }
            undiscovered.getAndIncrement();
            return false;
        }).toArray(ItemStack[]::new);
        this.undiscoveredItems = undiscovered.get();
        InfusionCodexSaveData.read(property);
        this.unobtainable = property.is(AlchemancyTags.Properties.CODEX_UNOBTAINABLE) && this.dormantItems.length == 0;
    }

    protected void init() {
        super.init();
        this.layout = new HeaderAndFooterLayout((Screen)this, 40, 32);
        LinearLayout footer = ((LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.vertical())).spacing(5);
        footer.defaultCellSetting().alignHorizontallyCenter();
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, p_329727_ -> this.onClose()).width(200).build());
        LinearLayout header = ((LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical())).spacing(5);
        header.addChild((LayoutElement)new TitleWidget(this.width, 16, this.font, this.property).alignCenter());
        header.addChild((LayoutElement)new StringWidget(this.width, 9, (Component)this.entry.flavor().copy().withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY), this.font).alignCenter());
        this.layout.addToContents((LayoutElement)new EntryBox(0, 0, this.width, this.height - this.layout.getHeaderHeight() - this.layout.getFooterHeight(), 32, 8));
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.arrangeElements();
    }

    private MutableComponent translated(String key) {
        return Component.translatable((String)"infusion_codex.%s.%s".formatted(this.property.getRegisteredName(), key));
    }

    private boolean hasTranslation(String key) {
        return I18n.exists((String)"infusion_codex.%s.%s".formatted(this.property.getRegisteredName(), key));
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    private static class TitleWidget
    extends StringWidget {
        private final ItemStack stack;
        private final Holder<Property> propertyHolder;
        private final float alignX = 0.5f;

        public TitleWidget(int width, int height, Font font, Holder<Property> propertyHolder) {
            super(width, height, (Component)Component.empty(), font);
            this.stack = InfusedPropertiesHelper.createPropertyCapsule(propertyHolder);
            this.propertyHolder = propertyHolder;
        }

        public Component getMessage() {
            return ((Property)this.propertyHolder.value()).getName(this.stack);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            int scale = 2;
            int yOff = 0;
            poseStack.scale((float)scale, (float)scale, 1.0f);
            this.setX(this.getX() / scale);
            this.setY(this.getY() / scale + yOff);
            this.setWidth(this.getWidth() / scale);
            this.setHeight(this.getHeight() / scale);
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            this.setX(this.getX() * scale);
            this.setY((this.getY() - yOff) * scale);
            this.setWidth(this.getWidth() * scale);
            this.setHeight(this.getHeight() * scale);
            poseStack.popPose();
            Component component = this.getMessage();
            Font font = this.getFont();
            int i = this.getWidth();
            int j = font.width((FormattedText)component) * scale;
            int k = this.getX() + Math.round(this.alignX * (float)(i - j));
            int l = this.getY() + (this.getHeight() - 9) / 2;
            guiGraphics.renderFakeItem(this.stack, k - 20, l - 4 + yOff * scale);
            guiGraphics.renderFakeItem(this.stack, k + j + 4, l - 4 + yOff * scale);
        }
    }

    class EntryBox
    extends AbstractWidget {
        final int xPadding;
        final int yPadding;
        private static final int itemPadding = 2;
        private static final int itemSize = 20;
        private static final int SCROLLBAR_WIDTH = 6;
        private float textYPointer;
        private float entryHeight;
        private float scrollAmount;
        private boolean scrolling;
        private static final String FORMAT_REGEX = "\\{([^\\}]*)\\}";

        public EntryBox(int x, int y, int width, int height, int xPadding, int yPadding) {
            super(x, y, width, height, (Component)Component.empty());
            this.xPadding = xPadding;
            this.yPadding = yPadding;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            float oldAmount = this.scrollAmount;
            Objects.requireNonNull(InfusionCodexEntryScreen.this.font);
            this.scrollAmount = Mth.clamp((float)(this.scrollAmount - (float)(scrollY * 9.0)), (float)0.0f, (float)this.getMaxScroll());
            return oldAmount != this.scrollAmount;
        }

        public float getMaxScroll() {
            return Math.max(0.0f, this.entryHeight - (float)this.getHeight());
        }

        public boolean scrollbarVisible() {
            return this.getMaxScroll() > 0.0f;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
            return this.scrolling;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (button == 0 && this.scrolling) {
                if (mouseY < (double)this.getY()) {
                    this.scrollAmount = 0.0f;
                } else if (mouseY > (double)this.getBottom()) {
                    this.scrollAmount = this.getMaxScroll();
                } else {
                    float d0 = Math.max(1.0f, this.getMaxScroll());
                    int i = this.height;
                    int j = Mth.clamp((int)((int)((float)(i * i) / (this.entryHeight - (float)this.getHeight()))), (int)32, (int)(i - 8));
                    float d1 = Math.max(1.0f, d0 / (float)(i - j));
                    this.scrollAmount = (float)Math.clamp((double)this.scrollAmount + dragY * (double)d1, 0.0, (double)this.getMaxScroll());
                }
                return true;
            }
            return false;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            List<Holder<Item>> innates;
            this.renderListBackground(guiGraphics);
            guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
            this.textYPointer = (float)this.yPadding - this.scrollAmount;
            if (InfusionCodexEntryScreen.this.unobtainable) {
                this.renderTextLine(guiGraphics, (Component)Component.translatable((String)"screen.infusion_codex.unobtainable"), 1.0f, 0xAA0000);
                this.textYPointer += 10.0f;
            } else if (InfusionCodexEntryScreen.this.property.is(AlchemancyTags.Properties.DISABLED)) {
                this.renderTextLine(guiGraphics, (Component)Component.translatable((String)"screen.infusion_codex.disabled"), 1.0f, 0xAA0000);
                this.textYPointer += 10.0f;
            }
            if (InfusionCodexEntryScreen.this.property.is(AlchemancyTags.Properties.SLOTLESS)) {
                this.renderTextLine(guiGraphics, (Component)Component.translatable((String)"screen.infusion_codex.slotless"), 1.0f, 0xFFAA00);
                this.textYPointer += 10.0f;
            }
            for (PropertyFunction function : InfusionCodexEntryScreen.this.entry.functions()) {
                this.renderFunctionParagraph(guiGraphics, function.localizationKey);
            }
            TooltipRendering tooltip = null;
            if (InfusionCodexEntryScreen.this.dormantItems.length > 0 || InfusionCodexEntryScreen.this.undiscoveredItems > 0) {
                this.renderTextLine(guiGraphics, (Component)Component.translatable((String)"screen.infusion_codex.dormant_properties"), 1.25f, 0x5555FF);
                int itemsPerRow = (this.width - this.xPadding * 2) / 20;
                int itemCount = InfusionCodexEntryScreen.this.dormantItems.length;
                for (int i = 0; i < itemCount; ++i) {
                    ItemStack stack = InfusionCodexEntryScreen.this.dormantItems[i];
                    int xx = this.getX() + this.xPadding + i % itemsPerRow * 20;
                    int yy = this.getY() + (int)this.textYPointer + i / itemsPerRow * 20;
                    guiGraphics.renderFakeItem(stack, xx, yy);
                    if (mouseX < xx - 2 || mouseX >= xx - 2 + 20 || mouseY < yy - 2 || mouseY >= yy - 2 + 20) continue;
                    tooltip = new ItemTooltip(stack);
                }
                if (InfusionCodexEntryScreen.this.undiscoveredItems > 0) {
                    int xx = this.getX() + this.xPadding + itemCount % itemsPerRow * 20;
                    int yy = this.getY() + (int)this.textYPointer + itemCount / itemsPerRow * 20;
                    Font font = InfusionCodexEntryScreen.this.font;
                    MutableComponent mutableComponent = Component.translatable((String)"screen.infusion_codex.undiscovered_items", (Object[])new Object[]{InfusionCodexEntryScreen.this.undiscoveredItems});
                    Objects.requireNonNull(InfusionCodexEntryScreen.this.font);
                    guiGraphics.drawString(font, (Component)mutableComponent, xx, yy + 10 - 9 / 2, 0xFFFFFF);
                    ++itemCount;
                    if (mouseX >= xx - 2 && mouseX < xx - 2 + 20 && mouseY >= yy - 2 && mouseY < yy - 2 + 20) {
                        tooltip = new TextTooltip(List.of(Component.translatable((String)"screen.infusion_codex.undiscovered_items.tooltip", (Object[])new Object[]{InfusionCodexEntryScreen.this.undiscoveredItems})));
                    }
                }
                this.textYPointer += (float)((itemCount - 1) / itemsPerRow * 20 + 10);
            }
            if (InfusionCodexEntryScreen.this.unobtainable && !(innates = InfusionCodexEntryScreen.this.entry.innates()).isEmpty()) {
                this.renderTextLine(guiGraphics, (Component)Component.translatable((String)"screen.infusion_codex.innate_properties"), 1.25f, 0x5555FF);
                int itemsPerRow = (this.width - this.xPadding * 2) / 20;
                int itemCount = innates.size();
                for (int i = 0; i < itemCount; ++i) {
                    ItemStack stack = ((Item)innates.get(i).value()).getDefaultInstance();
                    int xx = this.getX() + this.xPadding + i % itemsPerRow * 20;
                    int yy = this.getY() + (int)this.textYPointer + i / itemsPerRow * 20;
                    guiGraphics.renderFakeItem(stack, xx, yy);
                    if (mouseX < xx - 2 || mouseX >= xx - 2 + 20 || mouseY < yy - 2 || mouseY >= yy - 2 + 20) continue;
                    tooltip = new ItemTooltip(stack);
                }
                this.textYPointer += (float)((itemCount - 1) / itemsPerRow * 20 + 10);
            }
            guiGraphics.disableScissor();
            this.renderListSeparators(guiGraphics);
            if (this.scrollbarVisible()) {
                int l = this.getScrollbarPosition();
                int i1 = (int)((float)(this.height * this.height) / this.getMaxScroll());
                float k = (float)((int)this.scrollAmount * (this.height - (i1 = Mth.clamp((int)i1, (int)32, (int)(this.height - 8))))) / this.getMaxScroll() + (float)this.getY();
                if (k < (float)this.getY()) {
                    k = this.getY();
                }
                RenderSystem.enableBlend();
                guiGraphics.blitSprite(SCROLLER_BACKGROUND_SPRITE, l, this.getY(), 6, this.getHeight());
                guiGraphics.blitSprite(SCROLLER_SPRITE, l, (int)k, 6, i1);
                RenderSystem.disableBlend();
            }
            if (tooltip != null && mouseX >= this.getX() && mouseX <= this.getRight() && mouseY >= this.getY() && mouseY <= this.getBottom()) {
                tooltip.apply(guiGraphics, InfusionCodexEntryScreen.this.font, mouseX, mouseY);
            }
            this.entryHeight = this.textYPointer + 10.0f + this.scrollAmount;
        }

        private int getScrollbarPosition() {
            return this.getWidth() - this.xPadding;
        }

        private void renderFunctionParagraph(GuiGraphics guiGraphics, String functionKey) {
            this.renderTextLine(guiGraphics, (Component)Component.translatable((String)("screen.infusion_codex." + functionKey)), 1.25f, 0x5555FF);
            this.renderTextLine(guiGraphics, (Component)InfusionCodexEntryScreen.this.translated(functionKey), 1.0f, 0xFFFFFF);
            this.textYPointer += 10.0f;
        }

        public Component processFormatting(String formatType, String value) {
            return switch (formatType.toLowerCase()) {
                case "property" -> {
                    Optional property = CommonUtils.registryAccessStatic().registryOrThrow(AlchemancyProperties.REGISTRY_KEY).getOptional(ResourceLocation.parse((String)value));
                    yield property.map(Property::getName).orElse((Component)Component.literal((String)value).withColor(0xFF0000));
                }
                case "enchantment" -> {
                    Optional property = CommonUtils.registryAccessStatic().registryOrThrow(Registries.ENCHANTMENT).getOptional(ResourceLocation.parse((String)value));
                    yield property.map(block -> block.description().copy().withStyle(ChatFormatting.LIGHT_PURPLE)).orElse(Component.literal((String)value).withColor(0xFF0000));
                }
                case "function" -> Component.translatable((String)("screen.infusion_codex." + value)).withStyle(ChatFormatting.BLUE);
                case "shock" -> Component.literal((String)value).withColor(((ShockDamageProperty)AlchemancyProperties.SHOCKING.get()).getColor(ItemStack.EMPTY));
                case "arcane" -> Component.literal((String)value).withColor(((ArcaneProperty)AlchemancyProperties.ARCANE.get()).getColor(ItemStack.EMPTY));
                case "fire" -> Component.literal((String)value).withColor(((BurningProperty)AlchemancyProperties.BURNING.get()).getColor(ItemStack.EMPTY));
                case "item" -> Component.literal((String)value).withStyle(ChatFormatting.GREEN);
                case "attribute" -> Component.literal((String)value).withStyle(ChatFormatting.DARK_AQUA);
                case "system" -> Component.literal((String)value).withStyle(ChatFormatting.AQUA);
                case "nether" -> Component.literal((String)value).withStyle(ChatFormatting.RED);
                case "end" -> Component.literal((String)value).withStyle(ChatFormatting.DARK_PURPLE);
                case "activate" -> Component.literal((String)value).withColor(0xFF6366);
                case "hint" -> Component.literal((String)value).withColor(65535);
                case "property_list" -> {
                    MutableComponent component = Component.empty();
                    Iterable properties = ((Registry)AlchemancyProperties.REGISTRY.getRegistry().get()).getTagOrEmpty(TagKey.create(AlchemancyProperties.REGISTRY_KEY, (ResourceLocation)ResourceLocation.parse((String)value)));
                    int count = 0;
                    for (Object ignored : properties) {
                        ++count;
                    }
                    int i = 0;
                    for (Holder propertyHolder : properties) {
                        if (count == 1) {
                            component = component.append(((Property)propertyHolder.value()).getName());
                            continue;
                        }
                        component = component.append((Component)Component.translatable((String)("screen.infusion_codex.inline_list_entry" + (++i == count ? ".last" : "")), (Object[])new Object[]{((Property)propertyHolder.value()).getName()}));
                    }
                    yield component;
                }
                case "property_list_or" -> {
                    MutableComponent component = Component.empty();
                    Iterable properties = ((Registry)AlchemancyProperties.REGISTRY.getRegistry().get()).getTagOrEmpty(TagKey.create(AlchemancyProperties.REGISTRY_KEY, (ResourceLocation)ResourceLocation.parse((String)value)));
                    int count = 0;
                    for (Holder ignored : properties) {
                        ++count;
                    }
                    int i = 0;
                    for (Holder propertyHolder : properties) {
                        if (count == 1) {
                            component = component.append(((Property)propertyHolder.value()).getName());
                            continue;
                        }
                        component = component.append((Component)Component.translatable((String)("screen.infusion_codex.inline_list_entry" + (++i == count ? ".last_or" : "")), (Object[])new Object[]{((Property)propertyHolder.value()).getName()}));
                    }
                    yield component;
                }
                default -> Component.literal((String)value);
            };
        }

        public void renderTextLine(GuiGraphics guiGraphics, Component text, float scale, int color) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            if (scale != 1.0f) {
                poseStack.scale(scale, scale, 1.0f);
            }
            ArrayList things = new ArrayList();
            String str = text.getString();
            str = str.replace("%s", "");
            str = Pattern.compile(FORMAT_REGEX).matcher(str).replaceAll(matchResult -> {
                String found = matchResult.group();
                String[] params = (found = found.substring(1, found.length() - 1)).split(" ", 2);
                things.add(this.processFormatting(params.length < 2 ? "" : params[0], params[params.length - 1]));
                return "%s";
            });
            MutableComponent newText = Component.empty();
            int i = 0;
            for (String s : str.split("%s")) {
                newText = newText.append(s);
                if (i < things.size()) {
                    newText = newText.append((Component)things.get(i));
                }
                ++i;
            }
            for (FormattedCharSequence t : InfusionCodexEntryScreen.this.font.split((FormattedText)newText, this.width - this.xPadding * 2)) {
                guiGraphics.drawString(InfusionCodexEntryScreen.this.font, t, (float)(this.getX() + this.xPadding) / scale, ((float)this.getY() + this.textYPointer) / scale, color, true);
                Objects.requireNonNull(InfusionCodexEntryScreen.this.font);
                this.textYPointer += 9.0f * scale;
            }
            Objects.requireNonNull(InfusionCodexEntryScreen.this.font);
            this.textYPointer += 9.0f * 0.5f;
            poseStack.popPose();
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
            RenderSystem.enableBlend();
            ResourceLocation resourcelocation = INWORLD_MENU_LIST_BACKGROUND;
            guiGraphics.blit(resourcelocation, this.getX(), this.getY(), (float)this.getRight(), (float)this.getBottom(), this.getWidth(), this.getHeight(), 32, 32);
            RenderSystem.disableBlend();
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
            RenderSystem.enableBlend();
            guiGraphics.blit(Screen.INWORLD_HEADER_SEPARATOR, this.getX(), this.getY() - 2, 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
            guiGraphics.blit(Screen.INWORLD_FOOTER_SEPARATOR, this.getX(), this.getBottom(), 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
            RenderSystem.disableBlend();
        }

        record ItemTooltip(ItemStack stack) implements TooltipRendering
        {
            @Override
            public void apply(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY) {
                guiGraphics.renderTooltip(font, this.stack(), mouseX, mouseY);
            }
        }

        record TextTooltip(List<Component> lines) implements TooltipRendering
        {
            @Override
            public void apply(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY) {
                guiGraphics.renderTooltip(font, this.lines().stream().map(Component::getVisualOrderText).toList(), mouseX, mouseY);
            }
        }

        static interface TooltipRendering {
            public void apply(GuiGraphics var1, Font var2, int var3, int var4);
        }
    }
}

