/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class AlchemancyResourceArgument<T>
extends ResourceArgument<T> {
    private final HolderLookup<T> registryLookup;
    private final ResourceKey<? extends Registry> registryKey;

    private AlchemancyResourceArgument(CommandBuildContext context, ResourceKey<? extends Registry<T>> registryKey) {
        super(context, registryKey);
        this.registryLookup = context.lookupOrThrow(registryKey);
        this.registryKey = registryKey;
    }

    public static <T> AlchemancyResourceArgument<T> resource(CommandBuildContext context, ResourceKey<? extends Registry<T>> registryKey) {
        return new AlchemancyResourceArgument<T>(context, registryKey);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return AlchemancyResourceArgument.suggestResource(this.registryLookup.listElementIds().map(ResourceKey::location), builder);
    }

    private static CompletableFuture<Suggestions> suggestResource(Stream<ResourceLocation> resources, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        AlchemancyResourceArgument.filterResources(resources::iterator, s, p_82966_ -> p_82966_, p_82925_ -> builder.suggest(p_82925_.toString()));
        return builder.buildFuture();
    }

    private static <T> void filterResources(Iterable<T> resources, String input, Function<T, ResourceLocation> locationFunction, Consumer<T> resourceConsumer) {
        boolean flag = input.indexOf(58) > -1;
        for (T t : resources) {
            ResourceLocation resourcelocation = locationFunction.apply(t);
            if (flag) {
                String s = resourcelocation.toString();
                if (!SharedSuggestionProvider.matchesSubStr((String)input, (String)s)) continue;
                resourceConsumer.accept(t);
                continue;
            }
            if (!SharedSuggestionProvider.matchesSubStr((String)input, (String)resourcelocation.getNamespace()) && (!resourcelocation.getNamespace().equals("alchemancy") || !SharedSuggestionProvider.matchesSubStr((String)input, (String)resourcelocation.getPath()))) continue;
            resourceConsumer.accept(t);
        }
    }

    public static class Info<T>
    implements ArgumentTypeInfo<AlchemancyResourceArgument<T>, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.writeResourceKey(template.registryKey);
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new Template(buffer.readRegistryKey());
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("registry", template.registryKey.location().toString());
        }

        public Template unpack(AlchemancyResourceArgument<T> argument) {
            return new Template(argument.registryKey);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<AlchemancyResourceArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey<? extends Registry<T>> registryKey) {
                this.registryKey = registryKey;
            }

            public AlchemancyResourceArgument<T> instantiate(CommandBuildContext context) {
                return new AlchemancyResourceArgument(context, this.registryKey);
            }

            public ArgumentTypeInfo<AlchemancyResourceArgument<T>, ?> type() {
                return Info.this;
            }
        }
    }
}

