/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.cibernet.alchemancy.commands.AlchemancyResourceArgument;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.item.components.PropertyDataComponent;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class InfuseCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(p_304205_ -> Component.translatableEscape((String)"commands.alchemancy:infuse.failed.entity", (Object[])new Object[]{p_304205_}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(p_304207_ -> Component.translatableEscape((String)"commands.alchemancy:infuse.failed.itemless", (Object[])new Object[]{p_304207_}));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.alchemancy:infuse.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"infuse").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(((RequiredArgumentBuilder)Commands.argument((String)"property", AlchemancyResourceArgument.resource(context, AlchemancyProperties.REGISTRY_KEY)).executes(commandContext -> InfuseCommand.infuse((CommandSourceStack)commandContext.getSource(), EntityArgument.getEntities((CommandContext)commandContext, (String)"targets"), (Holder.Reference<Property>)ResourceArgument.getResource((CommandContext)commandContext, (String)"property", AlchemancyProperties.REGISTRY_KEY), new CompoundTag()))).then(Commands.argument((String)"propertyData", (ArgumentType)CompoundTagArgument.compoundTag()).executes(commandContext -> InfuseCommand.infuse((CommandSourceStack)commandContext.getSource(), EntityArgument.getEntities((CommandContext)commandContext, (String)"targets"), (Holder.Reference<Property>)ResourceArgument.getResource((CommandContext)commandContext, (String)"property", AlchemancyProperties.REGISTRY_KEY), CompoundTagArgument.getCompoundTag((CommandContext)commandContext, (String)"propertyData")))))));
    }

    private static int infuse(CommandSourceStack source, Collection<? extends Entity> targets, Holder.Reference<Property> property, CompoundTag propertyData) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                ItemStack itemstack = livingentity.getMainHandItem();
                if (!itemstack.isEmpty()) {
                    InfusedPropertiesHelper.addProperty(itemstack, property);
                    if (!propertyData.isEmpty() && property.value() instanceof IDataHolder) {
                        PropertyDataComponent.Mutable data = new PropertyDataComponent.Mutable((PropertyDataComponent)itemstack.getOrDefault(AlchemancyItems.Components.PROPERTY_DATA, (Object)PropertyDataComponent.EMPTY));
                        data.setDataNbt((Holder<Property>)property, propertyData);
                        itemstack.set(AlchemancyItems.Components.PROPERTY_DATA, (Object)data.toImmutable());
                    }
                    ++i;
                    continue;
                }
                if (targets.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)livingentity.getName().getString());
            }
            if (targets.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.getName().getString());
        }
        if (i == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.alchemancy:infuse.success.single", (Object[])new Object[]{((Property)property.value()).getName(), ((Entity)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.alchemancy:infuse.success.multiple", (Object[])new Object[]{((Property)property.value()).getName(), targets.size()}), true);
        }
        return i;
    }
}

