/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.cibernet.alchemancy.advancements.predicates.ForgeRecipePredicate;
import net.cibernet.alchemancy.blocks.blockentities.ItemStackHolderBlockEntity;
import net.cibernet.alchemancy.crafting.AbstractForgeRecipe;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.TintedProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyRecipeTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.TriState;
import org.apache.commons.lang3.function.TriFunction;

public class ForgeCustomNameRecipe
extends AbstractForgeRecipe<Object> {
    public final Ingredient ingredient;
    public final Optional<Holder<Property>> bold;
    public final Optional<Holder<Property>> italic;
    public final Optional<Holder<Property>> strikethrough;
    public final Optional<Holder<Property>> underlined;
    public final Optional<Holder<Property>> obfuscated;
    public final boolean canTint;

    protected ForgeCustomNameRecipe(Ingredient ingredient, Optional<Holder<Property>> bold, Optional<Holder<Property>> italic, Optional<Holder<Property>> strikethrough, Optional<Holder<Property>> underlined, Optional<Holder<Property>> obfuscated, Optional<Boolean> canTint) {
        super(Optional.empty(), Optional.empty(), List.of(), List.of());
        this.ingredient = ingredient;
        this.bold = bold;
        this.italic = italic;
        this.strikethrough = strikethrough;
        this.underlined = underlined;
        this.obfuscated = obfuscated;
        this.canTint = canTint.orElse(true);
    }

    @Override
    public boolean matches(ForgeRecipeGrid input, Level level) {
        return !this.ingredient.isEmpty() && input.testInfusables(List.of(this.ingredient), false);
    }

    @Override
    public TriFunction<ForgeRecipeGrid, HolderLookup.Provider, ItemStack, ItemStack> processResult() {
        return (grid, provider, stack) -> {
            MutableComponent name = Component.empty();
            boolean setName = false;
            for (ItemStackHolderBlockEntity pedestal : new ArrayList<ItemStackHolderBlockEntity>(grid.getItemPedestals())) {
                ItemStack pedestalStack = pedestal.getItem();
                if (!this.ingredient.test(pedestalStack)) continue;
                MutableComponent pedestalName = pedestalStack.getHoverName().copy();
                pedestalName.withStyle(style -> {
                    AtomicReference<Style> result = new AtomicReference<Style>((Style)style);
                    this.bold.ifPresent(propertyHolder -> result.set(((Style)result.get()).withBold(Boolean.valueOf(InfusedPropertiesHelper.hasProperty(pedestalStack, (Holder<Property>)propertyHolder)))));
                    this.italic.ifPresent(propertyHolder -> result.set(((Style)result.get()).withItalic(Boolean.valueOf(InfusedPropertiesHelper.hasProperty(pedestalStack, (Holder<Property>)propertyHolder)))));
                    this.strikethrough.ifPresent(propertyHolder -> result.set(((Style)result.get()).withStrikethrough(Boolean.valueOf(InfusedPropertiesHelper.hasProperty(pedestalStack, (Holder<Property>)propertyHolder)))));
                    this.underlined.ifPresent(propertyHolder -> result.set(((Style)result.get()).withUnderlined(Boolean.valueOf(InfusedPropertiesHelper.hasProperty(pedestalStack, (Holder<Property>)propertyHolder)))));
                    this.obfuscated.ifPresent(propertyHolder -> result.set(((Style)result.get()).withObfuscated(Boolean.valueOf(InfusedPropertiesHelper.hasProperty(pedestalStack, (Holder<Property>)propertyHolder)))));
                    if (this.canTint && InfusedPropertiesHelper.hasInfusedProperty(pedestalStack, AlchemancyProperties.TINTED)) {
                        Integer[] colors;
                        result.set(result.get().withColor((colors = (Integer[])((TintedProperty)AlchemancyProperties.TINTED.get()).getData(pedestalStack)).length > 0 ? colors[0] : TintedProperty.DEFAULT_COLOR));
                    }
                    return result.get();
                });
                setName = true;
                grid.consumeItem(pedestal);
                name.append((Component)pedestalName);
            }
            if (setName) {
                stack.set(DataComponents.CUSTOM_NAME, (Object)name);
            }
            return stack;
        };
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public TriState matches(ForgeRecipePredicate forgeRecipePredicate, ForgeRecipeGrid grid) {
        return TriState.DEFAULT;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AlchemancyRecipeTypes.Serializers.ALCHEMANCY_FORGE_CUSTOM_NAME.get();
    }

    public static class Serializer
    implements RecipeSerializer<ForgeCustomNameRecipe> {
        private static final MapCodec<ForgeCustomNameRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("infusable").forGetter(recipe -> recipe.ingredient), (App)Property.CODEC.optionalFieldOf("bold").forGetter(recipe -> recipe.bold), (App)Property.CODEC.optionalFieldOf("italic").forGetter(recipe -> recipe.italic), (App)Property.CODEC.optionalFieldOf("strikethrough").forGetter(recipe -> recipe.strikethrough), (App)Property.CODEC.optionalFieldOf("underlined").forGetter(recipe -> recipe.underlined), (App)Property.CODEC.optionalFieldOf("obfuscated").forGetter(recipe -> recipe.obfuscated), (App)Codec.BOOL.optionalFieldOf("can_tint").forGetter(recipe -> Optional.of(recipe.canTint))).apply((Applicative)instance, ForgeCustomNameRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ForgeCustomNameRecipe> STREAM_CODEC = StreamCodec.of((encoder, recipe) -> {
            Ingredient.CONTENTS_STREAM_CODEC.encode(encoder, (Object)recipe.ingredient);
            ByteBufCodecs.optional(Property.STREAM_CODEC).encode(encoder, recipe.bold);
            ByteBufCodecs.optional(Property.STREAM_CODEC).encode(encoder, recipe.italic);
            ByteBufCodecs.optional(Property.STREAM_CODEC).encode(encoder, recipe.strikethrough);
            ByteBufCodecs.optional(Property.STREAM_CODEC).encode(encoder, recipe.underlined);
            ByteBufCodecs.optional(Property.STREAM_CODEC).encode(encoder, recipe.obfuscated);
            encoder.writeBoolean(recipe.canTint);
        }, decoder -> new ForgeCustomNameRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(decoder), (Optional)ByteBufCodecs.optional(Property.STREAM_CODEC).decode(decoder), (Optional)ByteBufCodecs.optional(Property.STREAM_CODEC).decode(decoder), (Optional)ByteBufCodecs.optional(Property.STREAM_CODEC).decode(decoder), (Optional)ByteBufCodecs.optional(Property.STREAM_CODEC).decode(decoder), (Optional)ByteBufCodecs.optional(Property.STREAM_CODEC).decode(decoder), Optional.of(decoder.readBoolean())));

        public MapCodec<ForgeCustomNameRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ForgeCustomNameRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

