/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.crafting;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.blocks.AlchemancyForgeBlock;
import net.cibernet.alchemancy.blocks.InfusionPedestalBlock;
import net.cibernet.alchemancy.blocks.blockentities.ItemStackHolderBlockEntity;
import net.cibernet.alchemancy.crafting.AbstractForgeRecipe;
import net.cibernet.alchemancy.item.components.InfusedPropertiesComponent;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.registries.AlchemancyBlocks;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyRecipeTypes;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ForgeRecipeGrid
implements RecipeInput {
    private final ArrayList<ItemStackHolderBlockEntity> items = new ArrayList();
    private final ArrayList<Object> slotOrder = new ArrayList();
    private final ItemStackHolderBlockEntity forge;
    private ItemStack currentOutput;
    private Optional<Boolean> performingTransmutation = Optional.empty();
    public Optional<Boolean> applyGlint = Optional.empty();
    private final ArrayList<Holder<net.cibernet.alchemancy.properties.Property>> warpResults = new ArrayList();
    private static final RecipeManager.CachedCheck<ForgeRecipeGrid, AbstractForgeRecipe<?>> OUT_OF_FORGE_INTERACTIONS_CHECK = (input, level) -> level.getRecipeManager().getRecipesFor((RecipeType)AlchemancyRecipeTypes.ALCHEMANCY_FORGE.get(), input, level).stream().filter(recipe -> ((AbstractForgeRecipe)recipe.value()).matches((ForgeRecipeGrid)input, level) && !((AbstractForgeRecipe)recipe.value()).isTransmutation()).min(Comparator.comparingInt(recipe -> ((AbstractForgeRecipe)recipe.value()).getRecipeCompareValue((ForgeRecipeGrid)input)));
    private final Pair<Integer, Integer>[] slotOffsets = new Pair[]{new Pair((Object)1, (Object)0), new Pair((Object)1, (Object)1), new Pair((Object)0, (Object)1), new Pair((Object)-1, (Object)1), new Pair((Object)-1, (Object)0), new Pair((Object)-1, (Object)-1), new Pair((Object)0, (Object)-1), new Pair((Object)1, (Object)-1)};
    private List<Holder<net.cibernet.alchemancy.properties.Property>> cachedDormantProperties = null;

    public static ItemStack resolveInteractions(ItemStack input, Level level) {
        Optional recipe;
        ItemStack gridInput = input.copy();
        gridInput.setCount(1);
        ForgeRecipeGrid grid = new ForgeRecipeGrid(gridInput);
        for (int i = 0; i < 128 && (recipe = OUT_OF_FORGE_INTERACTIONS_CHECK.getRecipeFor((RecipeInput)grid, level)).isPresent(); ++i) {
            grid.processRecipe((AbstractForgeRecipe)((RecipeHolder)recipe.get()).value(), level.registryAccess());
        }
        ItemStack result = grid.getCurrentOutput();
        if (!result.isEmpty()) {
            result.setCount(result.getCount() * input.getCount());
        }
        return InfusedPropertiesHelper.truncateProperties(result);
    }

    public ItemStack getItem(int index) {
        return this.items.size() <= index ? ItemStack.EMPTY : this.items.get(0).getItem(0);
    }

    public ForgeRecipeGrid(ItemStack stack) {
        this.forge = new ItemStackHolderBlockEntity(BlockPos.ZERO, ((AlchemancyForgeBlock)((Object)AlchemancyBlocks.ALCHEMANCY_FORGE.get())).defaultBlockState());
        this.forge.setItem(stack);
        this.currentOutput = stack.copy();
    }

    public ForgeRecipeGrid(Level level, BlockPos pos, ItemStackHolderBlockEntity forge) {
        this.forge = forge;
        this.currentOutput = forge.getItem().copy();
        this.currentOutput.setCount(1);
        for (Pair<Integer, Integer> offset : this.slotOffsets) {
            Direction direction = (Direction)forge.getBlockState().getValue((Property)InfusionPedestalBlock.FACING);
            BlockPos lookupPos = pos.relative(direction, ((Integer)offset.getFirst()).intValue()).relative(direction.getClockWise(), ((Integer)offset.getSecond()).intValue());
            BlockEntity lookupBlockEntity = level.getBlockEntity(lookupPos);
            BlockState lookupState = level.getBlockState(lookupPos);
            if (!lookupState.is(AlchemancyBlocks.INFUSION_PEDESTAL) || !(lookupBlockEntity instanceof ItemStackHolderBlockEntity)) continue;
            ItemStackHolderBlockEntity pedestal = (ItemStackHolderBlockEntity)lookupBlockEntity;
            this.items.add(pedestal);
            this.slotOrder.add((Object)pedestal);
        }
    }

    public int size() {
        return this.items.size() + (this.forge.getItem().isEmpty() ? 0 : 1);
    }

    public boolean isEmpty() {
        return this.forge.isEmpty() && this.areIngredientsEmpty();
    }

    public boolean areIngredientsEmpty() {
        for (ItemStackHolderBlockEntity pedestal : this.items) {
            if (pedestal.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getCurrentOutput() {
        return this.currentOutput;
    }

    public ItemStackHolderBlockEntity getForge() {
        return this.forge;
    }

    public int getSlot(Object o) {
        return this.slotOrder.indexOf(o);
    }

    public int getSlotFor(Ingredient infusable) {
        for (ItemStackHolderBlockEntity item : this.items) {
            if (!infusable.test(item.getItem())) continue;
            return this.getSlot((Object)item);
        }
        return -1;
    }

    public int getRecipeCompareValue(AbstractForgeRecipe<?> recipe, List<Ingredient> infusables, List<Holder<net.cibernet.alchemancy.properties.Property>> properties, int priority) {
        int slots = 0;
        int slotValue = 0;
        if (!infusables.isEmpty()) {
            ArrayList<ItemStackHolderBlockEntity> items = new ArrayList<ItemStackHolderBlockEntity>(this.items);
            block0: for (Ingredient infusable : infusables) {
                int i = 0;
                for (ItemStackHolderBlockEntity item : items) {
                    if (infusable.test(item.getItem())) {
                        ++slots;
                        items.remove(i);
                        slotValue += this.getSlot((Object)item);
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        int infusionValue = 0;
        if (!properties.isEmpty()) {
            List<Holder> infusions = InfusedPropertiesHelper.getInfusedProperties(this.getCurrentOutput()).stream().sorted(Comparator.comparingInt(p -> ((net.cibernet.alchemancy.properties.Property)p.value()).getPriority())).toList();
            for (int i = 0; i < infusions.size(); ++i) {
                Holder infusion = infusions.get(i);
                infusionValue += properties.contains(infusion) ? 0 : i + 1;
            }
        }
        int result = (priority - AbstractForgeRecipe.MIN_PRIORITY << 9) + (8 - slots << 6) + Mth.clamp((int)slotValue, (int)0, (int)36) + infusionValue;
        return result;
    }

    public ArrayList<ItemStackHolderBlockEntity> getItemPedestals() {
        return this.items;
    }

    public boolean consumeItem(ItemStackHolderBlockEntity pedestal) {
        if (!this.slotOrder.contains((Object)pedestal)) {
            return false;
        }
        ItemStack stack = pedestal.getItem();
        if (stack.hasFoil()) {
            this.applyGlint = Optional.of(true);
        } else if (stack.is(AlchemancyTags.Items.INFUSION_REMOVES_GLINT)) {
            this.applyGlint = Optional.of(false);
        }
        pedestal.removeItem(1);
        this.markAsProcessed(pedestal);
        this.cachedDormantProperties = null;
        return true;
    }

    public void markAsProcessed(ItemStackHolderBlockEntity pedestal) {
        this.slotOrder.remove((Object)pedestal);
        this.items.remove((Object)pedestal);
    }

    public boolean testInfusables(List<Ingredient> infusables, boolean consume) {
        if (infusables.isEmpty()) {
            return true;
        }
        ArrayList<ItemStackHolderBlockEntity> items = consume ? this.items : new ArrayList<ItemStackHolderBlockEntity>(this.items);
        for (Ingredient infusable : infusables) {
            int i = 0;
            for (ItemStackHolderBlockEntity item : items) {
                ItemStack stack = item.getItem();
                if (infusable.test(stack)) {
                    if (!consume) break;
                    this.consumeItem(item);
                    break;
                }
                ++i;
            }
            if (i < items.size()) continue;
            return false;
        }
        return true;
    }

    public boolean testProperties(List<Holder<net.cibernet.alchemancy.properties.Property>> propertiesToTest, boolean consume) {
        if (propertiesToTest.isEmpty()) {
            return true;
        }
        if (!this.currentOutput.has(AlchemancyItems.Components.INFUSED_PROPERTIES)) {
            return false;
        }
        InfusedPropertiesComponent properties = (InfusedPropertiesComponent)this.currentOutput.get(AlchemancyItems.Components.INFUSED_PROPERTIES);
        for (Holder<net.cibernet.alchemancy.properties.Property> propertyHolder : propertiesToTest) {
            if (!properties.hasProperty(propertyHolder)) {
                return false;
            }
            if (!consume) continue;
            InfusedPropertiesHelper.removeProperty(this.currentOutput, propertyHolder);
        }
        return true;
    }

    public void processRecipe(AbstractForgeRecipe<?> recipe, RegistryAccess registryAccess) {
        this.currentOutput = recipe.assemble(this, (HolderLookup.Provider)registryAccess);
        this.performingTransmutation = Optional.of(recipe.isTransmutation());
    }

    public Optional<Boolean> getPerformingTransmutation() {
        return this.performingTransmutation;
    }

    public boolean canPerformTransmutation() {
        return this.performingTransmutation.isEmpty() || this.performingTransmutation.get() != false;
    }

    public boolean isPerformingTransmutation() {
        return this.performingTransmutation.isPresent() && this.performingTransmutation.get() != false;
    }

    public boolean handleDormantRecipes(boolean consume) {
        return this.handleDormantRecipes(this.currentOutput, consume);
    }

    public boolean handleDormantRecipes(ItemStack currentOutput, boolean consume) {
        if (this.forge.getItem().is(AlchemancyTags.Items.IMMUNE_TO_INFUSIONS)) {
            return false;
        }
        boolean success = false;
        for (ItemStackHolderBlockEntity pedestal : new ArrayList<ItemStackHolderBlockEntity>(this.items)) {
            ItemStack stack = pedestal.getItem();
            ItemStack target = !consume ? currentOutput.copy() : currentOutput;
            List<Holder<net.cibernet.alchemancy.properties.Property>> properties = AlchemancyProperties.getDormantProperties(stack);
            properties.addAll(((InfusedPropertiesComponent)stack.getOrDefault(AlchemancyItems.Components.STORED_PROPERTIES, (Object)InfusedPropertiesComponent.EMPTY)).properties());
            if (properties.isEmpty()) continue;
            boolean perform = false;
            AtomicBoolean consumeItem = new AtomicBoolean(true);
            for (Holder<net.cibernet.alchemancy.properties.Property> property : List.copyOf(properties)) {
                if (!InfusedPropertiesHelper.canInfuseWithProperty(currentOutput, property) || !((net.cibernet.alchemancy.properties.Property)property.value()).onInfusedByDormantProperty(target, stack, this, properties, consume)) continue;
                perform = true;
            }
            if (!perform) continue;
            if (consume) {
                properties.removeIf(propertyHolder -> !InfusedPropertiesHelper.canInfuseWithProperty(currentOutput, (Holder<net.cibernet.alchemancy.properties.Property>)propertyHolder));
                InfusedPropertiesHelper.addProperties(target, properties);
                if (consumeItem.get()) {
                    this.items.remove((Object)pedestal);
                    this.consumeItem(pedestal);
                }
            }
            success = true;
            break;
        }
        return success;
    }

    public List<Holder<net.cibernet.alchemancy.properties.Property>> getDormantProperties() {
        if (this.cachedDormantProperties != null) {
            return this.cachedDormantProperties;
        }
        ArrayList<Holder<net.cibernet.alchemancy.properties.Property>> result = new ArrayList<Holder<net.cibernet.alchemancy.properties.Property>>();
        for (ItemStackHolderBlockEntity pedestal : new ArrayList<ItemStackHolderBlockEntity>(this.items)) {
            ItemStack stack = pedestal.getItem();
            ItemStack target = this.currentOutput.copy();
            if (stack.is(AlchemancyTags.Items.REMOVES_INFUSIONS)) {
                result.clear();
                continue;
            }
            List<Holder<net.cibernet.alchemancy.properties.Property>> properties = AlchemancyProperties.getDormantProperties(stack);
            properties.addAll(((InfusedPropertiesComponent)stack.getOrDefault(AlchemancyItems.Components.STORED_PROPERTIES, (Object)InfusedPropertiesComponent.EMPTY)).properties());
            if (properties.isEmpty()) continue;
            boolean perform = false;
            for (Holder<net.cibernet.alchemancy.properties.Property> property : properties) {
                if (!((net.cibernet.alchemancy.properties.Property)property.value()).onInfusedByDormantProperty(target, stack, this, properties, false)) continue;
                perform = true;
            }
            if (!perform) continue;
            result.addAll(properties);
        }
        this.cachedDormantProperties = result;
        return result;
    }

    public boolean hasBeenWarped(List<Holder<net.cibernet.alchemancy.properties.Property>> properties) {
        for (Holder<net.cibernet.alchemancy.properties.Property> property : properties) {
            if (this.warpResults.contains(property)) continue;
            return false;
        }
        return true;
    }

    public void consumeWarped(List<Holder<net.cibernet.alchemancy.properties.Property>> properties) {
        this.warpResults.addAll(properties);
    }

    public boolean shouldConsumeWarped() {
        return !this.warpResults.isEmpty();
    }
}

