/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.crafting;

import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.crafting.ItemTransmutationRecipe;
import net.cibernet.alchemancy.item.components.InfusedPropertiesComponent;
import net.cibernet.alchemancy.item.components.PropertyDataComponent;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyRecipeTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.function.TriFunction;

public class PlayerHeadTransmutationRecipe
extends ItemTransmutationRecipe {
    public PlayerHeadTransmutationRecipe() {
        super(Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.PLAYER_HEAD})), Optional.empty(), List.of(), List.of(), Items.PLAYER_HEAD.getDefaultInstance());
    }

    @Override
    public Optional<String> getCatalystName() {
        if (ServerLifecycleHooks.getCurrentServer() == null || !(ServerLifecycleHooks.getCurrentServer() instanceof DedicatedServer) && Minecraft.getInstance().player != null) {
            return Optional.of(Minecraft.getInstance().player.getGameProfile().getName());
        }
        return super.getCatalystName();
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        ItemStack result = super.getResultItem(registries).copy();
        if (!(ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer() instanceof DedicatedServer || Minecraft.getInstance().player == null)) {
            result.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Minecraft.getInstance().player.getGameProfile()));
        }
        return result;
    }

    @Override
    public boolean matches(ForgeRecipeGrid input, Level level) {
        return input.getCurrentOutput().has(DataComponents.CUSTOM_NAME) && super.matches(input, level);
    }

    @Override
    public TriFunction<ForgeRecipeGrid, HolderLookup.Provider, ItemStack, ItemStack> processResult() {
        return (input, registries, output) -> {
            ItemStack result = this.result.copy();
            if (ItemStack.isSameItem((ItemStack)result, (ItemStack)input.getCurrentOutput())) {
                result.setCount(result.getCount() + input.getCurrentOutput().getCount() - 1);
            }
            String playerName = PlayerHeadTransmutationRecipe.toPlayerName(((Component)output.get(DataComponents.CUSTOM_NAME)).getString());
            result.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.of(playerName), Optional.empty(), new PropertyMap()));
            result.set(AlchemancyItems.Components.INFUSED_PROPERTIES, (Object)((InfusedPropertiesComponent)output.get(AlchemancyItems.Components.INFUSED_PROPERTIES)));
            result.set(AlchemancyItems.Components.PROPERTY_DATA, (Object)((PropertyDataComponent)output.get(AlchemancyItems.Components.PROPERTY_DATA)));
            return result;
        };
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AlchemancyRecipeTypes.Serializers.PLAYER_HEAD_TRANSMUTATION.get();
    }

    public static String toPlayerName(String playerName) {
        return playerName.substring(0, Math.min(playerName.length(), 16)).chars().filter(c -> c > 32 && c < 127).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static class Serializer
    implements RecipeSerializer<PlayerHeadTransmutationRecipe> {
        private final MapCodec<PlayerHeadTransmutationRecipe> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, PlayerHeadTransmutationRecipe> streamCodec;
        private final PlayerHeadTransmutationRecipe INSTANCE = new PlayerHeadTransmutationRecipe();

        public Serializer() {
            this.codec = RecordCodecBuilder.mapCodec(p_311736_ -> p_311736_.point((Object)this.INSTANCE));
            this.streamCodec = StreamCodec.unit((Object)this.INSTANCE);
        }

        public MapCodec<PlayerHeadTransmutationRecipe> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PlayerHeadTransmutationRecipe> streamCodec() {
            return this.streamCodec;
        }
    }
}

