/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.data.save;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.cibernet.alchemancy.util.RedstoneSources;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class AlchemancyLevelData
extends SavedData {
    private final Map<BlockPos, RedstoneSources.RedstoneSource> redstoneSources = new Object2ObjectOpenHashMap();

    public static AlchemancyLevelData compute(ServerLevel level) {
        return (AlchemancyLevelData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(AlchemancyLevelData::new, AlchemancyLevelData::load), "alchemancy");
    }

    public Map<BlockPos, RedstoneSources.RedstoneSource> getRedstoneSources() {
        return this.redstoneSources;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag redstoneSources = new ListTag();
        this.redstoneSources.forEach((pos, redstoneSource) -> {
            CompoundTag source = new CompoundTag();
            source.put("pos", NbtUtils.writeBlockPos((BlockPos)pos));
            source.put("data", (Tag)redstoneSource.write());
            redstoneSources.add((Object)source);
        });
        tag.put("redstone_sources", (Tag)redstoneSources);
        return tag;
    }

    private static AlchemancyLevelData load(CompoundTag tag, HolderLookup.Provider registries) {
        AlchemancyLevelData data = new AlchemancyLevelData();
        data.redstoneSources.clear();
        ListTag redstoneSources = tag.getList("restone_sources", 10);
        for (int i = 0; i < redstoneSources.size(); ++i) {
            CompoundTag source = redstoneSources.getCompound(i);
            NbtUtils.readBlockPos((CompoundTag)source, (String)"pos").ifPresent(pos -> data.redstoneSources.put((BlockPos)pos, RedstoneSources.RedstoneSource.read(source.getCompound("data"))));
        }
        return data;
    }
}

