/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.data.save;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.cibernet.alchemancy.AlchemancyConfig;
import net.cibernet.alchemancy.client.InfusionCodexToast;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.cibernet.alchemancy.util.SortOrder;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT})
public class InfusionCodexSaveData {
    public static final String FILE_PATH = "alchemancy/infusion_codex_save_data.json";
    private static final Gson GSON_INSTANCE = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static int maxRecencyIndex = 0;
    private static int minRecencyIndex = 0;
    private static int currentUnlockIndex = 0;
    private static SortOrder sortOrder = SortOrder.ALPHABETICAL;
    private static boolean dirty;
    private static final Map<ResourceLocation, EntryData> UNLOCKED_INFUSIONS;
    private static final List<ResourceLocation> DISCOVERED_ITEMS;
    private static final Codec<Unit> CODEC;

    private static void saveSortOrder() {
        JsonObject json;
        block15: {
            json = new JsonObject();
            File file = new File(FILE_PATH);
            if (file.exists()) {
                try (FileReader reader = new FileReader(file);){
                    json = (JsonObject)GSON_INSTANCE.fromJson((Reader)reader, JsonObject.class);
                    break block15;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            new File("alchemancy").mkdirs();
        }
        JsonElement sortOrderJson = (JsonElement)SortOrder.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)sortOrder).getOrThrow();
        json.add("sort_order", sortOrderJson);
        new File("alchemancy").mkdirs();
        try (FileWriter writer = new FileWriter(FILE_PATH);){
            GSON_INSTANCE.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void save() {
        JsonElement json = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)Unit.INSTANCE).getOrThrow();
        new File("alchemancy").mkdirs();
        try (FileWriter writer = new FileWriter(FILE_PATH);){
            GSON_INSTANCE.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void wipeData() {
        UNLOCKED_INFUSIONS.clear();
        DISCOVERED_ITEMS.clear();
        maxRecencyIndex = 0;
        minRecencyIndex = 0;
        currentUnlockIndex = 0;
    }

    public static void load() {
        InfusionCodexSaveData.wipeData();
        File file = new File(FILE_PATH);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                JsonElement json = (JsonElement)GSON_INSTANCE.fromJson((Reader)reader, JsonElement.class);
                CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static ResourceLocation getItemKey(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
    }

    public static SortOrder getSortOrder() {
        return sortOrder;
    }

    public static void setSortOrder(SortOrder sortOrder) {
        InfusionCodexSaveData.sortOrder = sortOrder;
        InfusionCodexSaveData.saveSortOrder();
    }

    public static boolean isItemDiscovered(ItemStack stack) {
        return InfusionCodexSaveData.isItemDiscovered(InfusionCodexSaveData.getItemKey(stack));
    }

    public static void discoverItem(ItemStack stack) {
        InfusionCodexSaveData.discoverItem(InfusionCodexSaveData.getItemKey(stack));
    }

    public static boolean isItemDiscovered(ResourceLocation stack) {
        return InfusionCodexSaveData.bypassesUnlocks() || DISCOVERED_ITEMS.contains(stack);
    }

    public static void discoverItem(ResourceLocation stack) {
        if (!InfusionCodexSaveData.isItemDiscovered(stack)) {
            DISCOVERED_ITEMS.add(stack);
            InfusionCodexSaveData.queueSave();
        }
    }

    public static boolean isUnlocked(Holder<Property> propertyHolder) {
        ResourceLocation key = InfusionCodexSaveData.getKey(propertyHolder);
        return key != null && (InfusionCodexSaveData.bypassesUnlocks() || UNLOCKED_INFUSIONS.containsKey(key) && InfusionCodexSaveData.UNLOCKED_INFUSIONS.get((Object)key).unlocked);
    }

    public static int getUnlockIndex(Holder<Property> propertyHolder) {
        ResourceLocation key = InfusionCodexSaveData.getKey(propertyHolder);
        if (!UNLOCKED_INFUSIONS.containsKey(key)) {
            return 0;
        }
        EntryData entry = UNLOCKED_INFUSIONS.get(key);
        return entry.unlocked ? -entry.unlockIndex : 0;
    }

    public static int getRecencyIndex(Holder<Property> propertyHolder) {
        ResourceLocation key = InfusionCodexSaveData.getKey(propertyHolder);
        return UNLOCKED_INFUSIONS.containsKey(key) ? -InfusionCodexSaveData.UNLOCKED_INFUSIONS.get((Object)key).recencyIndex : 0;
    }

    @Nullable
    private static ResourceLocation getKey(Holder<Property> propertyHolder) {
        return propertyHolder.unwrapKey().map(ResourceKey::location).orElse(null);
    }

    /*
     * Unable to fully structure code
     */
    public static List<Holder<Property>> getPropertiesToUnlock(ItemStack stack) {
        block4: {
            result = new ArrayList<Holder<Property>>();
            innates = InfusedPropertiesHelper.getInnateProperties(stack);
            result.addAll(innates);
            result.addAll(InfusedPropertiesHelper.getInfusedProperties(stack));
            result.addAll(InfusedPropertiesHelper.getStoredProperties(stack));
            includeDormants = stack.is(AlchemancyTags.Items.CODEX_DISCOVERY_ON_PICKUP);
            hasInnate = stack.has(AlchemancyItems.Components.INNATE_PROPERTIES);
            dormants = List.of();
            if (includeDormants || hasInnate) {
                dormants = AlchemancyProperties.getDormantProperties(stack);
            }
            if (!hasInnate) break block4;
            if (includeDormants) ** GOTO lbl-1000
            if (dormants.stream().anyMatch((Predicate<Holder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Lnet/minecraft/core/Holder;)Z)(innates))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = includeDormants = false;
            }
        }
        if (includeDormants) {
            result.addAll(AlchemancyProperties.getDormantProperties(stack));
        }
        return result;
    }

    public static void unlock(Holder<Property> propertyHolder) {
        ResourceLocation key = InfusionCodexSaveData.getKey(propertyHolder);
        if (key != null && !InfusionCodexSaveData.isUnlocked(propertyHolder)) {
            UNLOCKED_INFUSIONS.put(key, new EntryData(true));
            InfusionCodexToast.addOrUpdate(Minecraft.getInstance().getToasts(), propertyHolder);
            InfusionCodexSaveData.queueSave();
        }
    }

    public static void read(Holder<Property> propertyHolder) {
        ResourceLocation key = InfusionCodexSaveData.getKey(propertyHolder);
        if (key == null) {
            return;
        }
        if (!UNLOCKED_INFUSIONS.containsKey(key)) {
            UNLOCKED_INFUSIONS.put(key, new EntryData(false));
        }
        EntryData entry = UNLOCKED_INFUSIONS.get(key);
        entry.recencyIndex = ++maxRecencyIndex;
        entry.read = true;
        if (entry.recencyIndex <= 0 || entry.recencyIndex < minRecencyIndex) {
            minRecencyIndex = entry.recencyIndex;
        }
        InfusionCodexSaveData.queueSave();
    }

    public static boolean isRead(Holder<Property> propertyHolder) {
        return InfusionCodexSaveData.bypassesUnlocks() || UNLOCKED_INFUSIONS.containsKey(InfusionCodexSaveData.getKey(propertyHolder)) && InfusionCodexSaveData.UNLOCKED_INFUSIONS.get((Object)InfusionCodexSaveData.getKey(propertyHolder)).read;
    }

    public static boolean bypassesUnlocks() {
        return AlchemancyConfig.Client.codexDisplayMode().equals((Object)DisplayMode.NERD) || Minecraft.getInstance().player != null && Minecraft.getInstance().player.isCreative();
    }

    public static void queueSave() {
        dirty = true;
    }

    @SubscribeEvent
    private static void onClientTick(ClientTickEvent.Post event) {
        if (dirty) {
            InfusionCodexSaveData.save();
            dirty = false;
        }
    }

    @SubscribeEvent
    private static void onLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        InfusionCodexSaveData.load();
    }

    static {
        UNLOCKED_INFUSIONS = new HashMap<ResourceLocation, EntryData>();
        DISCOVERED_ITEMS = new ArrayList<ResourceLocation>();
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, EntryData.CODEC).fieldOf("unlocked_infusions").forGetter(data -> UNLOCKED_INFUSIONS), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("discovered_items").forGetter(data -> DISCOVERED_ITEMS), (App)SortOrder.CODEC.optionalFieldOf("sort_order", (Object)SortOrder.ALPHABETICAL).forGetter(data -> sortOrder)).apply((Applicative)instance, (unlockedInfusions, discoveredItems, order) -> {
            sortOrder = order;
            UNLOCKED_INFUSIONS.clear();
            UNLOCKED_INFUSIONS.putAll((Map<ResourceLocation, EntryData>)unlockedInfusions);
            DISCOVERED_ITEMS.clear();
            DISCOVERED_ITEMS.addAll((Collection<ResourceLocation>)discoveredItems);
            List<Integer> recencyIndexes = UNLOCKED_INFUSIONS.values().stream().map(data -> data.recencyIndex).filter(i -> i > 0).sorted().toList();
            if (!recencyIndexes.isEmpty()) {
                minRecencyIndex = recencyIndexes.getFirst();
                maxRecencyIndex = recencyIndexes.getLast();
            }
            UNLOCKED_INFUSIONS.values().stream().map(data -> data.unlockIndex).filter(i -> i > 0).sorted(Comparator.comparingInt(i -> -i.intValue())).findFirst().ifPresent(i -> {
                currentUnlockIndex = Math.max(0, i);
            });
            return Unit.INSTANCE;
        }));
    }

    public static class EntryData {
        public static final Codec<EntryData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("recency_index", (Object)0).forGetter(data -> data.recencyIndex == 0 ? 0 : data.recencyIndex - (minRecencyIndex - 1)), (App)Codec.INT.optionalFieldOf("unlock_index", (Object)0).forGetter(data -> data.unlocked ? data.unlockIndex : 0), (App)Codec.BOOL.optionalFieldOf("read", (Object)true).forGetter(data -> data.read), (App)Codec.BOOL.optionalFieldOf("unlocked", (Object)true).forGetter(data -> data.unlocked)).apply((Applicative)instance, EntryData::new));
        public int unlockIndex;
        protected int recencyIndex;
        protected boolean read = false;
        protected boolean unlocked;

        public EntryData(int recencyIndex, int unlockIndex, boolean read, boolean unlocked) {
            this.unlocked = unlocked;
            this.recencyIndex = recencyIndex;
            this.read = read;
            this.unlockIndex = !unlocked ? 0 : (unlockIndex <= 0 ? (currentUnlockIndex = currentUnlockIndex + 1) : unlockIndex);
        }

        public EntryData(boolean unlocked) {
            this.unlocked = unlocked;
            this.unlockIndex = ++currentUnlockIndex;
        }
    }

    public static enum DisplayMode {
        DEFAULT,
        SPOILER,
        NERD;

    }
}

