/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.datagen;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.cibernet.alchemancy.advancements.criterion.DiscoverPropertyTrigger;
import net.cibernet.alchemancy.datagen.AlchemancyLangProvider;
import net.cibernet.alchemancy.datagen.AlchemancyPropertyTagsProvider;
import net.cibernet.alchemancy.datagen.CodexEntryProvider;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="alchemancy")
public class AlchemancyDatagenHandler {
    public static final List<Holder<Property>> UNINFUSABLE_PROPERTIES = List.of(AlchemancyProperties.CLAY_MOLD, AlchemancyProperties.BADA_QUIP, AlchemancyProperties.RANDOM, AlchemancyProperties.WORLD_OBLITERATOR, AlchemancyProperties.AUXILIARY, AlchemancyProperties.SMITING, AlchemancyProperties.SCATTERSHOT, AlchemancyProperties.BATTERY_POWERED, AlchemancyProperties.LIVING_BATTERY, AlchemancyProperties.CEASELESS_VOID, AlchemancyProperties.UNMOVABLE);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(output, lookupProvider, fileHelper, List.of(AlchemancyDatagenHandler::getPropertyDiscoveryAdvancements, AlchemancyDatagenHandler::getAlchemancyMasterAdvancement)));
        generator.addProvider(event.includeClient(), (DataProvider)new AlchemancyLangProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new CodexEntryProvider(lookupProvider, output));
        generator.addProvider(event.includeClient(), (DataProvider)new AlchemancyPropertyTagsProvider(output, lookupProvider, fileHelper));
    }

    public static void getPropertyDiscoveryAdvancements(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        for (DeferredHolder property : AlchemancyProperties.REGISTRY.getEntries()) {
            ResourceLocation key = ((Property)property.value()).getKey();
            Advancement.Builder builder = Advancement.Builder.recipeAdvancement();
            builder.parent(AdvancementSubProvider.createPlaceholder((String)"alchemancy:discovery/root"));
            builder.display(InfusedPropertiesHelper.createPropertyCapsule(new Holder[]{property}), (Component)Component.translatable((String)("property." + key.toLanguageKey())), (Component)Component.translatable((String)"advancements.alchemancy:discovery.discover.description"), null, AdvancementType.TASK, false, false, true);
            builder.addCriterion("discover_property", DiscoverPropertyTrigger.TriggerInsance.discoverProperty((Holder<Property>)property));
            builder.requirements(AdvancementRequirements.allOf(List.of("discover_property")));
            builder.save(saver, ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)("discovery/" + key.getPath())), existingFileHelper);
        }
    }

    public static void getAlchemancyMasterAdvancement(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        Advancement.Builder builder = Advancement.Builder.recipeAdvancement();
        builder.parent(AdvancementSubProvider.createPlaceholder((String)"alchemancy:story/apply_property"));
        builder.display((ItemLike)AlchemancyItems.ALCHEMANCY_CATALYST.asItem(), (Component)Component.translatable((String)"advancements.story.alchemancy:all_properties.title"), (Component)Component.translatable((String)"advancements.story.alchemancy:all_properties.description"), null, AdvancementType.CHALLENGE, true, true, false);
        ArrayList<CallSite> requirements = new ArrayList<CallSite>();
        for (DeferredHolder property : AlchemancyProperties.REGISTRY.getEntries()) {
            if (UNINFUSABLE_PROPERTIES.contains(property)) continue;
            String key = "discover_" + ((Property)property.get()).getKey().toString();
            builder.addCriterion(key, DiscoverPropertyTrigger.TriggerInsance.discoverProperty((Holder<Property>)property));
            requirements.add((CallSite)((Object)key));
        }
        builder.requirements(AdvancementRequirements.allOf(requirements));
        builder.rewards(AdvancementRewards.Builder.experience((int)1000));
        builder.save(saver, ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"story/all_properties"), existingFileHelper);
    }
}

