/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.cibernet.alchemancy.client.data.CodexEntryReloadListenener;
import net.cibernet.alchemancy.item.components.InfusedPropertiesComponent;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.SparklingProperty;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class CodexEntryProvider
implements DataProvider {
    public static final HashMap<Holder<Property>, CodexEntryReloadListenener.CodexEntry> ENTRIES = new HashMap();
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final PackOutput.PathProvider pathProvider;

    public CodexEntryProvider(CompletableFuture<HolderLookup.Provider> registries, PackOutput packOutput) {
        this.registries = registries;
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "alchemancy/codex_entries");
    }

    public void populate() {
        for (Item item : BuiltInRegistries.ITEM) {
            if (!item.components().has((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get())) continue;
            ((InfusedPropertiesComponent)item.components().get((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get())).forEachProperty(propertyHolder -> CodexEntryProvider.addInnateItem((Holder<Property>)propertyHolder, (Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)item)));
        }
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.FLAMMABLE, List.of(AlchemancyProperties.CHARRED));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.ASSIMILATING, List.of(AlchemancyProperties.ASSEMBLING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.SANITIZED, List.of(AlchemancyProperties.INFECTED));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.INFECTED, List.of(AlchemancyProperties.SANITIZED, AlchemancyProperties.DEAD));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.SHATTERING, List.of(AlchemancyProperties.BRITTLE));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.SADDLED, List.of(AlchemancyProperties.WEALTHY, AlchemancyProperties.SWEET));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.SMELTING, List.of(AlchemancyProperties.HOLLOW, AlchemancyProperties.FLAMMABLE, AlchemancyProperties.CHARRED));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.DRIPPING, List.of(AlchemancyProperties.HOLLOW, AlchemancyProperties.BUCKETING, AlchemancyProperties.CAPTURING, AlchemancyProperties.CALCAREOUS));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.ABSORBING, List.of(AlchemancyProperties.BUCKETING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.MUSICAL, List.of(AlchemancyProperties.SPARKLING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.MYCELLIC, List.of(AlchemancyProperties.SPARKLING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.ROCKET_POWERED, List.of(AlchemancyProperties.SPARKLING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.AIR_WALKER, List.of(AlchemancyProperties.SPARKLING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.WAVE_RIDER, List.of(AlchemancyProperties.SPARKLING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.MAGNETIC, List.of(AlchemancyProperties.SPARKLING, AlchemancyProperties.FERROUS));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.KINETIC_GRAB, List.of(AlchemancyProperties.SPARKLING, AlchemancyProperties.EXTENDED));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.BLINKING, List.of(AlchemancyProperties.SPARKLING, AlchemancyProperties.EXTENDED));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.GUST_JET, List.of(AlchemancyProperties.SPARKLING, AlchemancyProperties.EXTENDED));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.WORLD_OBLITERATOR, List.of(AlchemancyProperties.SPARKLING, AlchemancyProperties.EXTENDED));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.MAGIC_RESISTANT, List.of(AlchemancyProperties.ARCANE));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.EDIBLE, List.of(AlchemancyProperties.SWIFT, AlchemancyProperties.EXTENDED, AlchemancyProperties.SLUGGISH));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.CEASELESS_VOID, List.of(AlchemancyProperties.SWIFT, AlchemancyProperties.EXTENDED, AlchemancyProperties.SLUGGISH));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.ENERGIZED, List.of(AlchemancyProperties.SHOCKING, AlchemancyProperties.SMITING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.CONDUCTIVE, List.of(AlchemancyProperties.SHOCKING, AlchemancyProperties.SMITING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.INSULATED, List.of(AlchemancyProperties.SHOCKING, AlchemancyProperties.SMITING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.WET, List.of(AlchemancyProperties.SHOCKING, AlchemancyProperties.SMITING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.FERROUS, List.of(AlchemancyProperties.SHOCKING, AlchemancyProperties.SMITING));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.EXTENDED, List.of(AlchemancyProperties.GUST_JET, AlchemancyProperties.BLINKING, AlchemancyProperties.KINETIC_GRAB, AlchemancyProperties.WORLD_OBLITERATOR));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.INFUSION_CODEX, List.of(AlchemancyProperties.REVEALED, AlchemancyProperties.REVEALING, AlchemancyProperties.AWAKENED));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.AWKWARD, List.of(AlchemancyProperties.BLINDING, AlchemancyProperties.FIRE_RESISTANT, AlchemancyProperties.TIPSY, AlchemancyProperties.NOCTURNAL, AlchemancyProperties.SWIFT, AlchemancyProperties.SANITIZED, AlchemancyProperties.LEAPING, AlchemancyProperties.AQUATIC));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.SOULBIND, List.of(AlchemancyProperties.VENGEFUL, AlchemancyProperties.VAMPIRIC, AlchemancyProperties.LOYAL, AlchemancyProperties.CAPTURING, AlchemancyProperties.PHASING, AlchemancyProperties.LIGHT_SEEKING, AlchemancyProperties.RELENTLESS, AlchemancyProperties.SPIRIT_BOND, AlchemancyProperties.ENERGY_SAPPER));
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.SPARKLING, SparklingProperty.getAllParticleProviders());
        CodexEntryProvider.addRelatedProperties(AlchemancyProperties.CLUELESS, AlchemancyProperties.REGISTRY.getEntries().stream().filter(p -> {
            IDataHolder dataHolder;
            Object patt0$temp = p.value();
            return patt0$temp instanceof IDataHolder && (dataHolder = (IDataHolder)patt0$temp).cluelessCanReset();
        }).collect(Collectors.toSet()));
    }

    public static void addRelatedProperties(Holder<Property> mainProperty, Collection<Holder<Property>> related) {
    }

    public static void addInnateItem(Holder<Property> propertyHolder, Holder<Item> innate) {
        if (ENTRIES.containsKey(propertyHolder)) {
            ENTRIES.get(propertyHolder).innates().add(innate);
        }
    }

    public CompletableFuture<?> run(CachedOutput output) {
        this.populate();
        return this.registries.thenCompose(lookup -> this.runLater(output));
    }

    protected CompletableFuture<?> runLater(CachedOutput output) {
        ArrayList list = new ArrayList();
        for (Map.Entry<Holder<Property>, CodexEntryReloadListenener.CodexEntry> entry : ENTRIES.entrySet()) {
            list.add(this.getEntryCompletable(output, entry.getKey(), entry.getValue()));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<?> getEntryCompletable(CachedOutput output, Holder<Property> propertyHolder, CodexEntryReloadListenener.CodexEntry codexEntry) {
        ResourceLocation key = propertyHolder.getKey().location();
        return DataProvider.saveStable((CachedOutput)output, (JsonElement)((JsonElement)CodexEntryReloadListenener.CodexEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)codexEntry).getOrThrow()), (Path)this.pathProvider.json(ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)key.getPath())));
    }

    public String getName() {
        return "Infusion Codex Entries";
    }
}

