/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.mixin.accessors.ClientLevelAccessor;
import net.cibernet.alchemancy.mixin.accessors.LevelRendererAccessor;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyEntities;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class InfusionFlask
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final double SPLASH_RANGE = 4.0;
    private static final int MAX_AFFECTED_ITEMS = 32;

    public InfusionFlask(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public InfusionFlask(Level level, double x, double y, double z) {
        super((EntityType)AlchemancyEntities.INFUSION_FLASK.get(), x, y, z, level);
    }

    public InfusionFlask(Level level, LivingEntity shooter) {
        super((EntityType)AlchemancyEntities.INFUSION_FLASK.get(), shooter, level);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.playSound(SoundEvents.SPLASH_POTION_BREAK, 1.0f, this.getRandom().nextFloat() * 0.1f + 0.9f);
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            List<Holder<Property>> infusions = this.getInfusions();
            if (!infusions.isEmpty()) {
                this.applySplash(infusions);
                this.level().broadcastEntityEvent((Entity)this, (byte)4);
            }
            this.discard();
        }
    }

    private List<Holder<Property>> getInfusions() {
        ItemStack itemstack = this.getItem().copy();
        ArrayList<Holder<Property>> infusions = new ArrayList<Holder<Property>>(itemstack.is(AlchemancyTags.Items.DISABLES_INFUSION_ABILITIES) ? InfusedPropertiesHelper.getInfusedProperties(itemstack) : InfusedPropertiesHelper.getStoredProperties(itemstack));
        infusions.removeIf(propertyHolder -> propertyHolder.is(AlchemancyTags.Properties.IGNORED_BY_INFUSION_FLASK));
        return infusions;
    }

    private void playSplashEffects() {
        if (!this.level().isClientSide()) {
            return;
        }
        ItemStack itemstack = this.getItem().copy();
        List<Holder<Property>> infusions = this.getInfusions();
        for (Holder<Property> infusion : infusions) {
            int color = ((Property)infusion.value()).getColor(itemstack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            SimpleParticleType particleoptions = ParticleTypes.INSTANT_EFFECT;
            Vec3 vec3 = this.position();
            for (int i2 = 0; i2 < 100; ++i2) {
                double power = this.getRandom().nextDouble() * 4.0;
                double angle = this.getRandom().nextDouble() * Math.PI * 2.0;
                double xSpeed = Math.cos(angle) * power;
                double ySpeed = 0.01 + this.getRandom().nextDouble() * 0.5;
                double zSpeed = Math.sin(angle) * power;
                Particle particle = ((LevelRendererAccessor)((ClientLevelAccessor)this.level()).getLevelRenderer()).invokeAddParticleInternal((ParticleOptions)particleoptions, particleoptions.getType().getOverrideLimiter(), vec3.x + xSpeed * 0.1, vec3.y + 0.3, vec3.z + zSpeed * 0.1, xSpeed, ySpeed, zSpeed);
                if (particle == null) continue;
                float colorOff = 0.75f + this.getRandom().nextFloat() * 0.25f;
                particle.setColor(r * colorOff, g * colorOff, b * colorOff);
                particle.setPower((float)power);
            }
        }
    }

    private ParticleOptions getParticle() {
        ItemStack itemstack = this.getItem();
        return new ItemParticleOption(ParticleTypes.ITEM, itemstack.isEmpty() ? this.getDefaultItem().getDefaultInstance() : itemstack);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int j = 0; j < 8; ++j) {
                this.level().addParticle(particleoptions, this.position().x, this.position().y, this.position().z, this.random.nextGaussian() * 0.15, this.random.nextDouble() * 0.2, this.random.nextGaussian() * 0.15);
            }
        } else if (id == 4) {
            this.playSplashEffects();
        }
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    private void applySplash(List<Holder<Property>> infusions) {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        int items = 0;
        for (LivingEntity living : this.level().getEntitiesOfClass(LivingEntity.class, aabb)) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                AtomicBoolean success = new AtomicBoolean(false);
                ItemStack entityStack = living.getItemBySlot(slot);
                if (entityStack.is(AlchemancyTags.Items.IGNORED_BY_INFUSION_FLASK)) continue;
                ItemStack splitStack = entityStack.split(32 - items);
                ItemStack itemStack = this.infuseItem(splitStack, infusions, success);
                if (!entityStack.isEmpty()) {
                    if (!itemStack.isEmpty()) {
                        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), living.getX(), living.getEyeY(), living.getZ(), itemStack));
                    }
                } else {
                    living.setItemSlot(slot, itemStack);
                }
                if (!success.get() || (items += splitStack.getCount()) < 32) continue;
                return;
            }
        }
        for (ItemEntity itemEntity : this.level().getEntitiesOfClass(ItemEntity.class, aabb)) {
            ItemStack entityStack = itemEntity.getItem();
            if (entityStack.is(AlchemancyTags.Items.IGNORED_BY_INFUSION_FLASK)) continue;
            AtomicBoolean success = new AtomicBoolean(false);
            ItemStack splitStack = entityStack.split(32 - items);
            ItemStack itemStack = this.infuseItem(splitStack, infusions, success);
            if (!entityStack.isEmpty()) {
                if (!itemStack.isEmpty()) {
                    ItemEntity newItem = new ItemEntity(this.level(), itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), itemStack);
                    newItem.setDefaultPickUpDelay();
                    this.level().addFreshEntity((Entity)newItem);
                }
            } else if (itemStack.isEmpty()) {
                itemEntity.discard();
            } else {
                itemEntity.setItem(itemStack);
            }
            if (!success.get() || (items += splitStack.getCount()) < 32) continue;
            return;
        }
    }

    private ItemStack infuseItem(ItemStack itemStack, List<Holder<Property>> infusions, AtomicBoolean successful) {
        if (itemStack.is(AlchemancyTags.Items.IMMUNE_TO_INFUSIONS)) {
            return itemStack;
        }
        boolean perform = false;
        ForgeRecipeGrid grid = new ForgeRecipeGrid(itemStack);
        for (Holder<Property> property : List.copyOf(infusions)) {
            if (!InfusedPropertiesHelper.canInfuseWithProperty(itemStack, property) || !((Property)property.value()).onInfusedByDormantProperty(itemStack, this.getItem(), grid, infusions, false)) continue;
            perform = true;
        }
        if (perform) {
            ItemStack finalItemStack = itemStack;
            infusions.removeIf(propertyHolder -> !InfusedPropertiesHelper.canInfuseWithProperty(finalItemStack, (Holder<Property>)propertyHolder));
            InfusedPropertiesHelper.addProperties(itemStack, infusions);
            InfusedPropertiesHelper.forEachProperty(finalItemStack, propertyHolder -> {
                Object patt0$temp;
                if (!propertyHolder.is(AlchemancyTags.Properties.CANNOT_CLONE_DATA) && (patt0$temp = propertyHolder.value()) instanceof IDataHolder) {
                    IDataHolder dataHolder = (IDataHolder)patt0$temp;
                    dataHolder.combineDataAndSet(finalItemStack, this.getItem());
                }
            }, false);
            itemStack = ForgeRecipeGrid.resolveInteractions(itemStack, this.level());
            successful.set(true);
        }
        return itemStack;
    }

    protected Item getDefaultItem() {
        return AlchemancyItems.INFUSION_FLASK.asItem();
    }
}

