/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.entity.ai;

import java.util.function.Predicate;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class TemptByRootedGoal
extends MoveToBlockGoal {
    private final Predicate<ItemStack> items;

    public TemptByRootedGoal(PathfinderMob mob, double speedModifier, Predicate<ItemStack> items) {
        super(mob, speedModifier, 24);
        this.items = items;
    }

    public TemptByRootedGoal(PathfinderMob mob, double speedModifier, Holder<Property> property) {
        this(mob, speedModifier, (ItemStack stack) -> InfusedPropertiesHelper.hasProperty(stack, property));
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        RootedItemBlockEntity root;
        BlockEntity blockEntity;
        ChunkAccess chunkaccess = level.getChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()), ChunkStatus.FULL, false);
        return chunkaccess != null && (blockEntity = chunkaccess.getBlockEntity(pos)) instanceof RootedItemBlockEntity && this.items.test((root = (RootedItemBlockEntity)blockEntity).getItem());
    }
}

