/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.events.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.cibernet.alchemancy.AlchemancyConfig;
import net.cibernet.alchemancy.crafting.ForgeRecipeGrid;
import net.cibernet.alchemancy.item.components.InfusedPropertiesComponent;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.item.components.PropertyDataComponent;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class InfusedLootHandler {
    private static final TagKey<Item> PROVIDES_ARROW = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"provides_arrow"));

    @SubscribeEvent
    private static void finalizeSpawn(FinalizeSpawnEvent event) {
        if (AlchemancyConfig.Server.infusedLoot() && event.getLevel().getRandom().nextFloat() < 0.01f) {
            InfusedLootHandler.markForInfusions((Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    private static void onEntityTick(EntityTickEvent.Pre event) {
        Entity entity;
        Level level = event.getEntity().level();
        if (!level.isClientSide() && AlchemancyConfig.Server.infusedLoot() && InfusedLootHandler.isMarkedForInfusions(event.getEntity()) && (entity = event.getEntity()) instanceof Mob) {
            Mob entity2 = (Mob)entity;
            List<EquipmentSlot> slots = Arrays.asList(EquipmentSlot.values());
            Collections.shuffle(slots);
            for (EquipmentSlot slot : slots) {
                ItemStack stack = entity2.getItemBySlot(slot);
                if (slot == EquipmentSlot.OFFHAND && stack.isEmpty() && entity2.getMainHandItem().is(PROVIDES_ARROW)) {
                    stack = Items.ARROW.getDefaultInstance();
                    stack.setCount(entity2.getRandom().nextInt(8) + 1);
                }
                if (stack.isEmpty()) continue;
                RandomSource randomSource = entity2.getRandom();
                if ((stack = InfusedLootHandler.applyRandomProperties(level, stack, slot.getName(), randomSource)).isEmpty()) break;
                entity2.setDropChance(slot, 1.0f);
                entity2.setItemSlot(slot, stack);
                break;
            }
            InfusedLootHandler.resolveMarkForInfusions((Entity)entity2);
        }
    }

    public static void infuseRandomItems(Level level, float luck, List<ItemStack> pool) {
        if (!AlchemancyConfig.Server.infusedLoot() || level.getRandom().nextFloat() < 0.02f) {
            return;
        }
        RandomSource randomSource = level.getRandom();
        ArrayList<ItemStack> poolCopy = new ArrayList<ItemStack>(pool);
        Collections.shuffle(poolCopy);
        Optional<ItemStack> tool = poolCopy.stream().filter(ItemStack::isDamageableItem).findAny();
        tool.ifPresent(stack -> InfusedLootHandler.applyRandomProperties(level, stack, Property.getEquipmentSlotForItem(stack).getName(), randomSource));
        poolCopy.removeIf(ItemStack::isDamageableItem);
        if (randomSource.nextBoolean()) {
            for (int i = 0; (float)i < (float)randomSource.nextInt(8) + luck && i < poolCopy.size(); ++i) {
                ItemStack stack2;
                InfusedLootHandler.applyRandomProperties(level, stack2, (stack2 = poolCopy.get(i)).has(DataComponents.FOOD) ? "food" : "material", randomSource);
            }
        }
    }

    private static ItemStack applyRandomProperties(Level level, ItemStack stack, String tagKey, RandomSource randomSource) {
        boolean success = false;
        for (int i = 0; i < 3 && randomSource.nextBoolean() && InfusedLootHandler.applyRandomProperty(level, stack, tagKey, randomSource, false); ++i) {
            success = true;
        }
        if (randomSource.nextFloat() < 0.05f) {
            InfusedLootHandler.applyRandomProperty(level, stack, tagKey, randomSource, true);
            success = true;
        }
        if (success) {
            ItemStack newStack = ForgeRecipeGrid.resolveInteractions(stack, level);
            stack.set(AlchemancyItems.Components.INFUSED_PROPERTIES, (Object)((InfusedPropertiesComponent)newStack.get(AlchemancyItems.Components.INFUSED_PROPERTIES)));
            stack.set(AlchemancyItems.Components.PROPERTY_DATA, (Object)((PropertyDataComponent)newStack.get(AlchemancyItems.Components.PROPERTY_DATA)));
            if (!InfusedPropertiesHelper.getInfusedProperties(stack).isEmpty()) {
                return newStack;
            }
        }
        return ItemStack.EMPTY;
    }

    private static boolean applyRandomProperty(Level level, ItemStack stack, String tagKey, RandomSource randomSource, boolean isRare) {
        Optional validProperties = level.registryAccess().lookupOrThrow(AlchemancyProperties.REGISTRY_KEY).get(InfusedLootHandler.getLootTag(tagKey, isRare));
        if (validProperties.isEmpty() || ((HolderSet.Named)validProperties.get()).stream().findAny().isEmpty()) {
            return false;
        }
        Optional property = ((HolderSet.Named)validProperties.get()).getRandomElement(randomSource);
        if (property.isEmpty()) {
            return false;
        }
        InfusedPropertiesHelper.addProperty(stack, (Holder<Property>)((Holder)property.get()));
        return true;
    }

    private static TagKey<Property> getLootTag(String tagKey, boolean isRare) {
        return TagKey.create(AlchemancyProperties.REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)("loot_infusions/" + (isRare ? "rare/" : "") + tagKey)));
    }

    private static void markForInfusions(Entity target) {
        target.getPersistentData().putBoolean("alchemancy:marked_for_infusions", true);
    }

    private static void resolveMarkForInfusions(Entity target) {
        target.getPersistentData().putBoolean("alchemancy:marked_for_infusions", false);
    }

    private static boolean isMarkedForInfusions(Entity target) {
        return target.getPersistentData().getBoolean("alchemancy:marked_for_infusions");
    }
}

