/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.events.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.cibernet.alchemancy.entity.ai.TemptByRootedGoal;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber
public class MobTemptHandler {
    private static final HashMap<Holder<Property>, Predicate<Entity>> PROPERTY_MAP = new HashMap();

    public static void registerTemptProperty(Holder<Property> property, Predicate<Entity> entityPredicate) {
        PROPERTY_MAP.put(property, entityPredicate);
    }

    public static void registerTemptProperty(Holder<Property> property, TagKey<EntityType<?>> entityTag) {
        MobTemptHandler.registerTemptProperty(property, (Entity entity) -> entity.getType().is(entityTag));
    }

    public static void performIfTempted(Entity entity, ItemStack stack, Action action) {
        for (Map.Entry<Holder<Property>, Predicate<Entity>> entry : PROPERTY_MAP.entrySet()) {
            if (entry.getKey().is(AlchemancyTags.Properties.DISABLED) || !InfusedPropertiesHelper.hasInfusedProperty(stack, entry.getKey()) || !entry.getValue().test(entity)) continue;
            action.perform();
            return;
        }
    }

    public static void performIfTempted(Entity entity, LivingEntity user, EquipmentSlotGroup slots, Action action) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!slots.test(slot)) continue;
            ItemStack stack = user.getItemBySlot(slot);
            for (Map.Entry<Holder<Property>, Predicate<Entity>> entry : PROPERTY_MAP.entrySet()) {
                if (!InfusedPropertiesHelper.hasInfusedProperty(stack, entry.getKey()) || !entry.getValue().test(entity)) continue;
                action.perform();
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            mob.goalSelector.addGoal(2, (Goal)new TemptGoal(mob, 1.0, stack -> InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.CHARMING), false));
            mob.goalSelector.addGoal(0, (Goal)new TemptByRootedGoal(mob, 1.0, (Holder<Property>)AlchemancyProperties.CHARMING));
            PROPERTY_MAP.forEach((propertyHolder, entityPredicate) -> {
                if (entityPredicate.test(mob)) {
                    mob.goalSelector.addGoal(3, (Goal)new TemptGoal(mob, 1.25, stack -> InfusedPropertiesHelper.hasProperty(stack, (Holder<Property>)propertyHolder), false));
                    mob.goalSelector.addGoal(0, (Goal)new TemptByRootedGoal(mob, 1.25, (Holder<Property>)propertyHolder));
                }
            });
        }
    }

    static {
        MobTemptHandler.registerTemptProperty(AlchemancyProperties.SWEET, AlchemancyTags.EntityTypes.TEMPTED_BY_SWEET);
        MobTemptHandler.registerTemptProperty(AlchemancyProperties.WEALTHY, AlchemancyTags.EntityTypes.TEMPTED_BY_WEALTHY);
        MobTemptHandler.registerTemptProperty(AlchemancyProperties.SEEDED, AlchemancyTags.EntityTypes.AGGROED_BY_SEEDED);
        MobTemptHandler.registerTemptProperty(AlchemancyProperties.PUTRID, AlchemancyTags.EntityTypes.TEMPTED_BY_PUTRID);
    }

    public static interface Action {
        public void perform();
    }
}

