/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.events.handler.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.cibernet.alchemancy.data.save.AlchemancyServerData;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.TintedProperty;
import net.cibernet.alchemancy.registries.AlchemancyDataAttachments;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.util.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderArmEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().level != null && !Minecraft.getInstance().isPaused() && !Minecraft.getInstance().isLocalServer()) {
            AlchemancyServerData.tickGlobalTimer();
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && !player.getUseItem().canPerformAction(ItemAbilities.SHIELD_BLOCK) && InfusedPropertiesHelper.hasProperty(player.getUseItem(), AlchemancyProperties.SHIELDING) && player.getUsedItemHand() == event.getHand()) {
            PoseStack poseStack = event.getPoseStack();
            int sign = event.getHand() == (player.getMainArm() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND) ? 1 : -1;
            poseStack.translate((float)(-sign) * 0.25f, 0.4f, -0.25f);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)sign * 75.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(270.0f));
        }
    }

    @SubscribeEvent
    public static void onRenderArm(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        if (!player.hasData(AlchemancyDataAttachments.ENTITY_TINT.get())) {
            return;
        }
        List tint = (List)player.getData(AlchemancyDataAttachments.ENTITY_TINT.get());
        if (tint.isEmpty()) {
            return;
        }
        Vector3f tintVec = Vec3.fromRGB24((int)ColorUtils.interpolateColorsOverTime(1.0f, tint.stream().mapToInt(Integer::intValue).toArray())).toVector3f();
        RenderSystem.setShaderColor((float)tintVec.x(), (float)tintVec.y(), (float)tintVec.z(), (float)RenderSystem.getShaderColor()[3]);
    }

    @SubscribeEvent
    public static void modifyFogColor(ViewportEvent.ComputeFogColor event) {
        @Nullable Vector3f tint = ClientEventHandler.getScreenTintColor();
        if (tint == null) {
            return;
        }
        event.setRed(event.getRed() * tint.x());
        event.setGreen(event.getGreen() * tint.y());
        event.setBlue(event.getBlue() * tint.z());
    }

    public static boolean modifySkyColor(float red, float green, float blue, float alpha, Operation<Void> original) {
        @Nullable Vector3f tint = ClientEventHandler.getScreenTintColor();
        if (tint != null) {
            original.call(new Object[]{Float.valueOf(red * tint.x()), Float.valueOf(green * tint.y()), Float.valueOf(blue * tint.z()), Float.valueOf(alpha)});
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onStageRender(RenderLevelStageEvent event) {
        @Nullable Vector3f tint = ClientEventHandler.getScreenTintColor();
        if (tint == null) {
            return;
        }
        float[] shaderColor = RenderSystem.getShaderColor();
        RenderSystem.setShaderColor((float)tint.x(), (float)tint.y(), (float)tint.z(), (float)shaderColor[3]);
    }

    @SubscribeEvent
    public static void onStageRender(RenderFrameEvent.Pre event) {
        @Nullable Vector3f tint = ClientEventHandler.getScreenTintColor();
        if (tint == null) {
            return;
        }
        float[] shaderColor = RenderSystem.getShaderColor();
    }

    @Nullable
    private static Vector3f getScreenTintColor() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return null;
        }
        ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (!InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.TINTED_LENS)) {
            return null;
        }
        return Vec3.fromRGB24((int)(InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.TINTED) ? ((TintedProperty)AlchemancyProperties.TINTED.get()).getColor(stack) : ((Property)AlchemancyProperties.TINTED_LENS.get()).getColor(stack))).toVector3f();
    }
}

