/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.item.components;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public record InfusedPropertiesComponent(List<Holder<Property>> properties) {
    public static final Codec<InfusedPropertiesComponent> CODEC = Codec.list(Property.CODEC).xmap(InfusedPropertiesComponent::new, a -> a.properties);
    public static final StreamCodec<RegistryFriendlyByteBuf, InfusedPropertiesComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)AlchemancyProperties.REGISTRY.getRegistryKey()).apply(ByteBufCodecs.list()), comp -> comp.properties, InfusedPropertiesComponent::new);
    public static final InfusedPropertiesComponent EMPTY = new InfusedPropertiesComponent(new ArrayList<Holder<Property>>());

    public void forEachProperty(Consumer<Holder<Property>> consumer, boolean ignoreDisabled) {
        this.properties.stream().sorted(Comparator.comparingInt(p -> ((Property)p.value()).getPriority())).filter(property -> !ignoreDisabled || !property.is(AlchemancyTags.Properties.DISABLED)).forEach(consumer);
    }

    public void forEachProperty(Consumer<Holder<Property>> consumer) {
        this.forEachProperty(consumer, true);
    }

    public boolean hasProperty(Holder<Property> property) {
        return !property.is(AlchemancyTags.Properties.DISABLED) && this.properties.contains(property);
    }

    public boolean hasProperty(TagKey<Property> propertyTag) {
        return this.properties.stream().anyMatch(property -> property.is(propertyTag) && !property.is(AlchemancyTags.Properties.DISABLED));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof InfusedPropertiesComponent)) return false;
        InfusedPropertiesComponent itemenchantments = (InfusedPropertiesComponent)other;
        if (!this.properties.equals(itemenchantments.properties)) return false;
        return true;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("[");
        for (Holder<Property> holder : this.properties) {
            str.append(((Property)holder.value()).getKey()).append(" ");
        }
        str.append("]");
        return str.toString();
    }

    public static class Mutable {
        private final List<Holder<Property>> properties;

        public Mutable(InfusedPropertiesComponent component) {
            this.properties = new ArrayList<Holder<Property>>(component.properties);
        }

        public boolean hasProperty(Holder<Property> property) {
            return this.properties.contains(property);
        }

        public boolean addProperty(Holder<Property> property) {
            if (!this.hasProperty(property)) {
                return this.properties.add(property);
            }
            return false;
        }

        public boolean removeProperty(Holder<Property> property) {
            return this.properties.remove(property);
        }

        public boolean truncateProperties(int limit) {
            List<Holder> slotless = List.copyOf(this.properties).stream().filter(propertyHolder -> propertyHolder.is(AlchemancyTags.Properties.SLOTLESS)).toList();
            if (this.properties.size() - slotless.size() <= limit) {
                return false;
            }
            this.properties.removeIf(slotless::contains);
            this.properties.subList(limit, this.properties.size()).clear();
            this.properties.addAll(slotless);
            return true;
        }

        public InfusedPropertiesComponent toImutable() {
            return new InfusedPropertiesComponent(this.properties);
        }
    }
}

