/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.item.components;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.cibernet.alchemancy.item.components.InfusedPropertiesComponent;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.SparklingProperty;
import net.cibernet.alchemancy.properties.ToggleableProperty;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InfusedPropertiesHelper {
    public static final int DEFAULT_INFUSION_SLOTS = 4;

    public static boolean hasItemWithProperty(LivingEntity user, Holder<Property> property, boolean checkAuxiliary) {
        return InfusedPropertiesHelper.hasItemWithProperty(user, property, checkAuxiliary, EquipmentSlotGroup.ANY);
    }

    public static boolean hasItemWithProperty(LivingEntity user, Holder<Property> property, boolean checkAuxiliary, EquipmentSlotGroup equipmentSlots) {
        ItemStack stack;
        if (checkAuxiliary && user instanceof Player) {
            Player player = (Player)user;
            Inventory inventory = player.getInventory();
            List<Holder<Property>> propertiesToCheck = List.of(AlchemancyProperties.AUXILIARY, property);
            for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
                stack = inventory.getItem(slot);
                if (!InfusedPropertiesHelper.hasProperties(stack, propertiesToCheck, true)) continue;
                return true;
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!equipmentSlots.test(slot) || !InfusedPropertiesHelper.hasProperty(stack = user.getItemBySlot(slot), property)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProperty(ItemStack stack, Holder<Property> property) {
        if (!property.isBound() || stack == null || stack.isEmpty() || property == null || property.is(AlchemancyTags.Properties.DISABLED)) {
            return false;
        }
        boolean toggled = (Boolean)((ToggleableProperty)AlchemancyProperties.TOGGLEABLE.get()).getData(stack);
        return (toggled || !InfusedPropertiesHelper.hasInfusedProperty(stack, AlchemancyProperties.TOGGLEABLE)) && InfusedPropertiesHelper.hasInfusedProperty(stack, property) || (toggled || !InfusedPropertiesHelper.hasInnateProperty(stack, AlchemancyProperties.TOGGLEABLE)) && (property == AlchemancyProperties.DEAD || !InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.DEAD)) && InfusedPropertiesHelper.hasInnateProperty(stack, property) || InfusedPropertiesHelper.hasInfusedProperty(stack, AlchemancyProperties.AWAKENED) && InfusedPropertiesHelper.hasDormantProperty(stack, property);
    }

    public static boolean hasProperty(ItemStack stack, TagKey<Property> propertyTag) {
        if (stack == null || stack.isEmpty() || propertyTag == null) {
            return false;
        }
        boolean toggled = (Boolean)((ToggleableProperty)AlchemancyProperties.TOGGLEABLE.get()).getData(stack);
        return (toggled || !InfusedPropertiesHelper.hasInfusedProperty(stack, AlchemancyProperties.TOGGLEABLE)) && InfusedPropertiesHelper.hasInfusedProperty(stack, propertyTag) || (toggled || !InfusedPropertiesHelper.hasInnateProperty(stack, AlchemancyProperties.TOGGLEABLE)) && InfusedPropertiesHelper.hasInnateProperty(stack, propertyTag) || InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.AWAKENED) && InfusedPropertiesHelper.hasDormantProperty(stack, propertyTag);
    }

    public static boolean hasProperties(ItemStack stack, List<Holder<Property>> properties, boolean matchesAll) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        for (Holder<Property> property : properties) {
            if (InfusedPropertiesHelper.hasProperty(stack, property) == matchesAll) continue;
            return !matchesAll;
        }
        return matchesAll;
    }

    public static boolean hasInfusedProperty(ItemStack stack, Holder<Property> property) {
        return stack != null && !stack.isEmpty() && AlchemancyItems.Components.INFUSED_PROPERTIES.isBound() && stack.has((DataComponentType)AlchemancyItems.Components.INFUSED_PROPERTIES.get()) && ((InfusedPropertiesComponent)stack.get((DataComponentType)AlchemancyItems.Components.INFUSED_PROPERTIES.get())).hasProperty(property);
    }

    public static boolean hasInnateProperty(ItemStack stack, Holder<Property> property) {
        return stack != null && AlchemancyItems.Components.INNATE_PROPERTIES.isBound() && !stack.isEmpty() && stack.has((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get()) && ((InfusedPropertiesComponent)stack.get((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get())).hasProperty(property);
    }

    public static boolean hasDormantProperty(ItemStack stack, Holder<Property> property) {
        return stack != null && !stack.isEmpty() && AlchemancyProperties.getDormantProperties(stack).contains(property);
    }

    public static boolean hasInfusedProperty(ItemStack stack, TagKey<Property> propertyTag) {
        return stack != null && !stack.isEmpty() && AlchemancyItems.Components.INFUSED_PROPERTIES.isBound() && !stack.is(AlchemancyTags.Items.DISABLES_INFUSION_ABILITIES) && stack.has((DataComponentType)AlchemancyItems.Components.INFUSED_PROPERTIES.get()) && ((InfusedPropertiesComponent)stack.get((DataComponentType)AlchemancyItems.Components.INFUSED_PROPERTIES.get())).hasProperty(propertyTag);
    }

    public static boolean hasInnateProperty(ItemStack stack, TagKey<Property> propertyTag) {
        return stack != null && !stack.isEmpty() && AlchemancyItems.Components.INNATE_PROPERTIES.isBound() && stack.has((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get()) && ((InfusedPropertiesComponent)stack.get((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get())).hasProperty(propertyTag);
    }

    public static boolean hasDormantProperty(ItemStack stack, TagKey<Property> propertyTag) {
        return stack != null && !stack.isEmpty() && AlchemancyProperties.getDormantProperties(stack).stream().anyMatch(property -> property.is(propertyTag));
    }

    public static boolean modifyInfusions(ItemStack stack, Function<InfusedPropertiesComponent.Mutable, Boolean> consumer) {
        InfusedPropertiesComponent.Mutable mutable = new InfusedPropertiesComponent.Mutable((InfusedPropertiesComponent)stack.getOrDefault((DataComponentType)AlchemancyItems.Components.INFUSED_PROPERTIES.get(), (Object)InfusedPropertiesComponent.EMPTY));
        boolean result = consumer.apply(mutable);
        stack.set((DataComponentType)AlchemancyItems.Components.INFUSED_PROPERTIES.get(), (Object)mutable.toImutable());
        return result;
    }

    public static void forEachProperty(ItemStack stack, Consumer<Holder<Property>> consumer) {
        InfusedPropertiesHelper.forEachProperty(stack, consumer, true);
    }

    public static void forEachProperty(ItemStack stack, Consumer<Holder<Property>> consumer, boolean checkToggle) {
        boolean toggled;
        if (stack == null || stack.isEmpty()) {
            return;
        }
        boolean bl = toggled = !checkToggle || AlchemancyProperties.TOGGLEABLE.isBound() && (Boolean)((ToggleableProperty)AlchemancyProperties.TOGGLEABLE.get()).getData(stack) != false;
        if (AlchemancyItems.Components.INNATE_PROPERTIES.isBound() && !InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.DEAD) && stack.has((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get())) {
            if (!toggled && InfusedPropertiesHelper.hasInnateProperty(stack, AlchemancyProperties.TOGGLEABLE)) {
                consumer.accept((Holder<Property>)AlchemancyProperties.TOGGLEABLE);
            } else {
                ((InfusedPropertiesComponent)stack.get((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get())).forEachProperty(consumer);
            }
        }
        if (AlchemancyItems.Components.INFUSED_PROPERTIES.isBound() && stack.has((DataComponentType)AlchemancyItems.Components.INFUSED_PROPERTIES.get()) && !stack.is(AlchemancyTags.Items.DISABLES_INFUSION_ABILITIES)) {
            if (!toggled && InfusedPropertiesHelper.hasInfusedProperty(stack, AlchemancyProperties.TOGGLEABLE)) {
                consumer.accept((Holder<Property>)AlchemancyProperties.TOGGLEABLE);
            } else {
                ((InfusedPropertiesComponent)stack.get((DataComponentType)AlchemancyItems.Components.INFUSED_PROPERTIES.get())).forEachProperty(consumer);
            }
        }
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.AWAKENED)) {
            AlchemancyProperties.getDormantProperties(stack).forEach(consumer);
        }
    }

    public static void forEachInnateProperty(ItemStack stack, Consumer<Holder<Property>> consumer) {
        if (!AlchemancyItems.Components.INNATE_PROPERTIES.isBound() || stack == null || stack.isEmpty()) {
            return;
        }
        boolean toggled = (Boolean)((ToggleableProperty)AlchemancyProperties.TOGGLEABLE.get()).getData(stack);
        if (stack.has((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get())) {
            if (!toggled && InfusedPropertiesHelper.hasInnateProperty(stack, AlchemancyProperties.TOGGLEABLE)) {
                consumer.accept((Holder<Property>)AlchemancyProperties.TOGGLEABLE);
            } else {
                ((InfusedPropertiesComponent)stack.get((DataComponentType)AlchemancyItems.Components.INNATE_PROPERTIES.get())).forEachProperty(consumer);
            }
        }
        if (InfusedPropertiesHelper.hasInnateProperty(stack, AlchemancyProperties.AWAKENED)) {
            AlchemancyProperties.getDormantProperties(stack).forEach(consumer);
        }
    }

    public static boolean canInfuseWithProperty(ItemStack stack, Holder<Property> propertyHolder) {
        if (stack.is(AlchemancyItems.SPARKLING_BAND)) {
            return SparklingProperty.hasParticles(propertyHolder);
        }
        return true;
    }

    public static ItemStack addProperty(ItemStack stack, Holder<Property> property) {
        InfusedPropertiesHelper.modifyInfusions(stack, mutable -> mutable.addProperty(property));
        return stack;
    }

    public static ItemStack addProperties(ItemStack stack, List<Holder<Property>> properties) {
        InfusedPropertiesHelper.modifyInfusions(stack, mutable -> {
            properties.forEach(mutable::addProperty);
            return !properties.isEmpty();
        });
        return stack;
    }

    public static ItemStack removeProperty(ItemStack stack, Holder<Property> property) {
        if (stack.has(AlchemancyItems.Components.INFUSED_PROPERTIES)) {
            InfusedPropertiesHelper.modifyInfusions(stack, mutable -> mutable.removeProperty(property));
            Object object = property.value();
            if (object instanceof IDataHolder) {
                IDataHolder dataHolder = (IDataHolder)object;
                dataHolder.removeData(stack);
            }
            if (InfusedPropertiesHelper.getInfusedProperties(stack).isEmpty()) {
                stack.remove(AlchemancyItems.Components.INFUSED_PROPERTIES);
            }
        }
        return stack;
    }

    public static int getInfusionSlots(ItemStack stack) {
        return Math.max(0, (Integer)stack.getOrDefault((DataComponentType)AlchemancyItems.Components.INFUSION_SLOTS.get(), (Object)4));
    }

    public static ItemStack truncateProperties(ItemStack stack) {
        if (stack.has(AlchemancyItems.Components.INFUSED_PROPERTIES)) {
            do {
                InfusedPropertiesHelper.truncateProperties(stack, InfusedPropertiesHelper.getInfusionSlots(stack));
            } while (InfusedPropertiesHelper.getRemainingInfusionSlots(stack) < 0);
            return stack;
        }
        return stack;
    }

    public static int getRemainingInfusionSlots(ItemStack stack) {
        List<Holder<Property>> infusedProperties = InfusedPropertiesHelper.getInfusedProperties(stack);
        return InfusedPropertiesHelper.getInfusionSlots(stack) - (infusedProperties.size() - (int)infusedProperties.stream().filter(propertyHolder -> propertyHolder.is(AlchemancyTags.Properties.SLOTLESS)).count());
    }

    public static ItemStack truncateProperties(ItemStack stack, int limit) {
        if (limit <= 0) {
            stack.remove(AlchemancyItems.Components.INFUSED_PROPERTIES);
        } else {
            int finalLimit = limit;
            InfusedPropertiesHelper.modifyInfusions(stack, mutable -> mutable.truncateProperties(finalLimit));
        }
        return stack;
    }

    public static ItemStack clearAllInfusions(ItemStack stack) {
        stack.remove(AlchemancyItems.Components.INFUSED_PROPERTIES);
        stack.remove(AlchemancyItems.Components.PROPERTY_DATA);
        return stack;
    }

    public static List<Holder<Property>> getInfusedProperties(ItemStack stack) {
        if (!AlchemancyItems.Components.INFUSED_PROPERTIES.isBound()) {
            return InfusedPropertiesComponent.EMPTY.properties();
        }
        return ((InfusedPropertiesComponent)stack.getOrDefault(AlchemancyItems.Components.INFUSED_PROPERTIES, (Object)InfusedPropertiesComponent.EMPTY)).properties();
    }

    public static List<Holder<Property>> getInnateProperties(ItemStack stack) {
        if (!AlchemancyItems.Components.INNATE_PROPERTIES.isBound()) {
            return InfusedPropertiesComponent.EMPTY.properties();
        }
        return ((InfusedPropertiesComponent)stack.getOrDefault(AlchemancyItems.Components.INNATE_PROPERTIES, (Object)InfusedPropertiesComponent.EMPTY)).properties();
    }

    public static List<Holder<Property>> getStoredProperties(ItemStack stack) {
        if (!AlchemancyItems.Components.STORED_PROPERTIES.isBound()) {
            return InfusedPropertiesComponent.EMPTY.properties();
        }
        return ((InfusedPropertiesComponent)stack.getOrDefault(AlchemancyItems.Components.STORED_PROPERTIES, (Object)InfusedPropertiesComponent.EMPTY)).properties();
    }

    public static ItemStack storeProperties(ItemStack stack, List<Holder<Property>> properties) {
        stack.set(AlchemancyItems.Components.STORED_PROPERTIES, (Object)new InfusedPropertiesComponent(properties));
        return stack;
    }

    @SafeVarargs
    public static ItemStack storeProperties(ItemStack stack, Holder<Property> ... properties) {
        return InfusedPropertiesHelper.storeProperties(stack, Arrays.asList(properties));
    }

    public static ItemStack createPropertyCapsule(List<Holder<Property>> properties) {
        return InfusedPropertiesHelper.storeProperties(AlchemancyItems.PROPERTY_CAPSULE.toStack(), properties);
    }

    @SafeVarargs
    public static ItemStack createPropertyCapsule(Holder<Property> ... properties) {
        return InfusedPropertiesHelper.storeProperties(AlchemancyItems.PROPERTY_CAPSULE.toStack(), properties);
    }

    public static ItemStack createPropertyIngredient(List<Holder<Property>> properties) {
        ItemStack result = InfusedPropertiesHelper.createPropertyCapsule(properties);
        result.set(AlchemancyItems.Components.INGREDIENT_DISPLAY, (Object)Unit.INSTANCE);
        return result;
    }

    @SafeVarargs
    public static ItemStack createPropertyIngredient(Holder<Property> ... properties) {
        ItemStack result = InfusedPropertiesHelper.createPropertyCapsule(properties);
        result.set(AlchemancyItems.Components.INGREDIENT_DISPLAY, (Object)Unit.INSTANCE);
        return result;
    }
}

