/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.item.components;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.modifiers.PropertyModifierType;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public record PropertyModifierComponent(Map<Holder<Property>, Map<Holder<PropertyModifierType<?>>, Object>> map) {
    public static final PropertyModifierComponent DEFAULT = new PropertyModifierComponent(new HashMap());
    public static Codec<Map<Holder<PropertyModifierType<?>>, Object>> MAP_CODEC = Codec.dispatchedMap(PropertyModifierType.CODEC, type -> ((PropertyModifierType)type.value()).codec());
    public static StreamCodec<RegistryFriendlyByteBuf, Map<Holder<PropertyModifierType<?>>, Object>> MAP_STREAM_CODEC = StreamCodec.of((encode, map) -> {
        encode.writeInt(map.size());
        for (Map.Entry entry : map.entrySet()) {
            PropertyModifierType.STREAM_CODEC.encode(encode, (Object)((Holder)entry.getKey()));
            ((PropertyModifierType)((Holder)entry.getKey()).value()).encode((RegistryFriendlyByteBuf)encode, entry.getValue());
        }
    }, decode -> {
        int size = decode.readInt();
        HashMap<Holder, Object> map = new HashMap<Holder, Object>();
        for (int i = 0; i < size; ++i) {
            Holder key = (Holder)PropertyModifierType.STREAM_CODEC.decode(decode);
            map.put(key, ((PropertyModifierType)key.value()).streamCodec().decode(decode));
        }
        return map;
    });
    public static Codec<PropertyModifierComponent> CODEC = Codec.unboundedMap(Property.CODEC, MAP_CODEC).xmap(PropertyModifierComponent::new, PropertyModifierComponent::map);
    public static StreamCodec<RegistryFriendlyByteBuf, PropertyModifierComponent> STREAM_CODEC = StreamCodec.of((encode, comp) -> {
        encode.writeInt(comp.map.size());
        for (Map.Entry<Holder<Property>, Map<Holder<PropertyModifierType<?>>, Object>> entry : comp.map.entrySet()) {
            Property.STREAM_CODEC.encode(encode, entry.getKey());
            MAP_STREAM_CODEC.encode(encode, entry.getValue());
        }
    }, decode -> {
        int size = decode.readInt();
        HashMap map = new HashMap();
        for (int i = 0; i < size; ++i) {
            map.put((Holder<Property>)((Holder)Property.STREAM_CODEC.decode(decode)), (Map)MAP_STREAM_CODEC.decode(decode));
        }
        return new PropertyModifierComponent(map);
    });

    public <T> T get(Holder<Property> property, DeferredHolder<PropertyModifierType<?>, PropertyModifierType<T>> type) {
        return this.getOrElse(property, type, ((PropertyModifierType)type.value()).defaultValue());
    }

    public <T> T getOrElse(Holder<Property> property, DeferredHolder<PropertyModifierType<?>, PropertyModifierType<T>> type, T defaultValue) {
        return (T)(this.map.containsKey(property) ? this.map.get(property).getOrDefault(type, defaultValue) : defaultValue);
    }

    public static <T> T get(ItemStack stack, Holder<Property> property, DeferredHolder<PropertyModifierType<?>, PropertyModifierType<T>> type) {
        return PropertyModifierComponent.getOrElse(stack, property, type, ((PropertyModifierType)type.value()).defaultValue());
    }

    public static <T> T getOrElse(ItemStack stack, Holder<Property> property, DeferredHolder<PropertyModifierType<?>, PropertyModifierType<T>> type, T defaultValue) {
        return stack.has(AlchemancyItems.Components.PROPERTY_MODIFIERS) ? ((PropertyModifierComponent)stack.get(AlchemancyItems.Components.PROPERTY_MODIFIERS)).getOrElse(property, type, defaultValue) : defaultValue;
    }

    public static <T> void set(ItemStack stack, Holder<Property> property, DeferredHolder<PropertyModifierType<?>, PropertyModifierType<T>> type, T value) {
        stack.set(AlchemancyItems.Components.PROPERTY_MODIFIERS, (Object)new Mutable((PropertyModifierComponent)stack.getOrDefault(AlchemancyItems.Components.PROPERTY_MODIFIERS, (Object)DEFAULT)).setPropertyModifier(property, type, value).toImutable());
    }

    public static class Mutable {
        private final Map<Holder<Property>, Map<Holder<PropertyModifierType<?>>, Object>> modifiers;

        public Mutable(PropertyModifierComponent component) {
            this.modifiers = new HashMap(component.map);
        }

        public boolean hasProperty(Holder<Property> property) {
            return this.modifiers.containsKey(property);
        }

        public <T> Mutable setPropertyModifier(Holder<Property> property, DeferredHolder<PropertyModifierType<?>, PropertyModifierType<T>> modifier, T value) {
            Map<Holder<PropertyModifierType<?>>, Object> thing;
            if (!this.hasProperty(property)) {
                this.modifiers.put(property, new HashMap());
            }
            if ((thing = this.modifiers.get(property)) instanceof ImmutableMap) {
                thing = new HashMap(thing);
                this.modifiers.put(property, thing);
            }
            this.modifiers.get(property).put((Holder<PropertyModifierType<?>>)modifier, value);
            return this;
        }

        public void removePropertyModifiers(Holder<Property> property) {
            this.modifiers.remove(property);
        }

        public PropertyModifierComponent toImutable() {
            return new PropertyModifierComponent(this.modifiers);
        }
    }
}

