/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.cibernet.alchemancy.events.handler.MobTemptHandler;
import net.cibernet.alchemancy.mixin.accessors.EntityAccessor;
import net.cibernet.alchemancy.network.S2CRidePlayerPayload;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    protected abstract float getRiddenSpeed(Player var1);

    @Shadow
    public abstract double getAttributeValue(Holder<Attribute> var1);

    @Shadow
    public abstract Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 var1, float var2);

    @Shadow
    public abstract void travel(Vec3 var1);

    @Inject(method={"dismountVehicle"}, at={@At(value="HEAD")})
    public void dismountVehicle(Entity vehicle, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (vehicle instanceof ServerPlayer) {
            ServerPlayer other = (ServerPlayer)vehicle;
            PacketDistributor.sendToPlayer((ServerPlayer)other, (CustomPacketPayload)new S2CRidePlayerPayload(self.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @WrapOperation(method={"createLivingAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier;builder()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;")})
    private static AttributeSupplier.Builder createLivingAttributes(Operation<AttributeSupplier.Builder> original) {
        AttributeSupplier.Builder result = (AttributeSupplier.Builder)original.call(new Object[0]);
        if (!result.hasAttribute(Attributes.ATTACK_DAMAGE)) {
            result.add(Attributes.ATTACK_DAMAGE, 1.0);
        }
        return result;
    }

    @Inject(method={"getRiddenInput"}, at={@At(value="HEAD")}, cancellable=true)
    public void getRiddenInput(Player player, Vec3 travelVector, CallbackInfoReturnable<Vec3> cir) {
        MobTemptHandler.performIfTempted((Entity)this.alchemancy$self(), (LivingEntity)player, EquipmentSlotGroup.HAND, () -> cir.setReturnValue((Object)new Vec3(0.0, (double)(-Mth.sin((float)(player.getXRot() * ((float)Math.PI / 180)))), 1.0)));
    }

    @Inject(method={"tickRidden"}, at={@At(value="RETURN")})
    public void riddenTick(Player player, Vec3 travelVector, CallbackInfo ci) {
        LivingEntity self = this.alchemancy$self();
        if (!(self instanceof ItemSteerable)) {
            MobTemptHandler.performIfTempted((Entity)self, (LivingEntity)player, EquipmentSlotGroup.HAND, () -> {
                self.setYRot(player.getYRot());
                self.setXRot(player.getXRot() * 0.5f);
                self.yBodyRot = self.yHeadRot = self.getYRot();
                self.yRotO = self.yHeadRot;
                float f2 = self.level().getBlockState(self.getBlockPosBelowThatAffectsMyMovement()).getFriction((LevelReader)self.level(), self.getBlockPosBelowThatAffectsMyMovement(), (Entity)self);
                Vec3 frictionTravelVector = EntityAccessor.invokeGetInputVector(travelVector, f2, self.getYRot()).add(self.getDeltaMovement());
                Vec3 collidedTravelVector = ((EntityAccessor)self).invokeCollide(frictionTravelVector);
                if (!Mth.equal((double)frictionTravelVector.x, (double)collidedTravelVector.x) || !Mth.equal((double)frictionTravelVector.z, (double)collidedTravelVector.z)) {
                    self.horizontalCollision = true;
                }
            });
        }
    }

    @Inject(method={"getRiddenSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    public void getRiddenSpeed(Player player, CallbackInfoReturnable<Float> cir) {
        MobTemptHandler.performIfTempted((Entity)this.alchemancy$self(), (LivingEntity)player, EquipmentSlotGroup.HAND, () -> cir.setReturnValue((Object)Float.valueOf((float)(this.getAttributeValue((Holder<Attribute>)Attributes.MOVEMENT_SPEED) * (double)0.225f))));
    }

    @Unique
    private LivingEntity alchemancy$self() {
        return (LivingEntity)this;
    }
}

