/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.mixin;

import javax.annotation.Nullable;
import net.cibernet.alchemancy.events.handler.MobTemptHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin {
    @Shadow
    @Final
    public GoalSelector goalSelector;

    @Shadow
    @Nullable
    public abstract LivingEntity getControllingPassenger();

    @Inject(method={"getControllingPassenger"}, at={@At(value="HEAD")}, cancellable=true)
    public void getControllingPassenger(CallbackInfoReturnable<LivingEntity> cir) {
        Entity entity = this.alchemancy$self().getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            MobTemptHandler.performIfTempted((Entity)this.alchemancy$self(), living, EquipmentSlotGroup.HAND, () -> cir.setReturnValue((Object)((LivingEntity)((Mob)this).getFirstPassenger())));
        }
    }

    @Inject(method={"updateControlFlags"}, at={@At(value="RETURN")})
    public void updateControlFlags(CallbackInfo ci) {
        Entity entity = this.alchemancy$self().getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            MobTemptHandler.performIfTempted((Entity)this.alchemancy$self(), living, EquipmentSlotGroup.HAND, () -> {
                this.goalSelector.setControlFlag(Goal.Flag.MOVE, true);
                this.goalSelector.setControlFlag(Goal.Flag.LOOK, true);
            });
        }
    }

    @Unique
    private Mob alchemancy$self() {
        return (Mob)this;
    }
}

