/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.modSupport.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.cibernet.alchemancy.crafting.AbstractForgeRecipe;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractForgingRecipe<T extends AbstractForgeRecipe<?>>
implements IRecipeCategory<T> {
    private final ResourceLocation ARROW = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"textures/gui/jei/conversion_arrow.png");
    private final ResourceLocation DIAGRAM = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"textures/gui/jei/forge_diagram.png");
    private final ResourceLocation OUTPUT = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"textures/gui/jei/property_output_slot.png");
    private final IDrawable icon;
    protected static final int RADIUS = 24;

    public AbstractForgingRecipe(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)AlchemancyItems.INFUSION_PEDESTAL.toStack());
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 112;
    }

    public int getHeight() {
        return 64;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(this.ARROW, 64, 24, 0.0f, 0.0f, 32, 16, 32, 16);
        guiGraphics.blit(this.DIAGRAM, 8, 8, 0.0f, 0.0f, 48, 48, 48, 48);
        if (this.getOutput(recipe).isEmpty()) {
            guiGraphics.blit(this.OUTPUT, 96, 24, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public abstract ItemStack getOutput(T var1);

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        int i;
        int xOff = 24;
        int yOff = 24;
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(((AbstractForgeRecipe)recipe).getInfusables());
        List<ItemStack> propertyCapsules = ((AbstractForgeRecipe)recipe).getInfusedProperties().stream().map(xva$0 -> InfusedPropertiesHelper.createPropertyIngredient(xva$0)).toList();
        float totalSize = ingredients.size() + propertyCapsules.size();
        for (i = 0; i < propertyCapsules.size(); ++i) {
            builder.addInputSlot(xOff - (int)(24.0f * Mth.sin((float)((float)Math.PI + (float)Math.PI * 2 * ((float)i / totalSize)))), yOff + (int)(24.0f * Mth.cos((float)((float)Math.PI + (float)Math.PI * 2 * ((float)i / totalSize))))).addItemStack(propertyCapsules.get(i));
        }
        for (i = 0; i < ingredients.size(); ++i) {
            builder.addInputSlot(xOff - (int)(24.0f * Mth.sin((float)((float)Math.PI + (float)Math.PI * 2 * ((float)(i + propertyCapsules.size()) / totalSize)))), yOff + (int)(24.0f * Mth.cos((float)((float)Math.PI + (float)Math.PI * 2 * ((float)(i + propertyCapsules.size()) / totalSize))))).addIngredients(ingredients.get(i));
        }
        if (((AbstractForgeRecipe)recipe).getCatalyst().isPresent()) {
            builder.addInputSlot(xOff, yOff).addIngredients(((AbstractForgeRecipe)recipe).getCatalyst().get());
        }
        builder.addOutputSlot(xOff + 24 + 48, yOff).addItemStack(this.getOutput(recipe));
    }
}

