/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.modSupport.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.cibernet.alchemancy.crafting.PropertyWarpRecipe;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.modSupport.jei.AlchemancyJeiPlugin;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class PropertyWarpingCategory
implements IRecipeCategory<PropertyWarpRecipe> {
    private final IDrawable icon;
    private final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"textures/gui/jei/conversion_arrow.png");
    private final Component TITLE = Component.translatable((String)"recipe.alchemancy.property_warping");

    protected PropertyWarpingCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.WARPED_WART_BLOCK.getDefaultInstance());
    }

    public RecipeType<PropertyWarpRecipe> getRecipeType() {
        return AlchemancyJeiPlugin.PROPERTY_WARPING;
    }

    public Component getTitle() {
        return this.TITLE;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 64;
    }

    public int getHeight() {
        return 16;
    }

    public void draw(PropertyWarpRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(this.TEXTURE_LOCATION, 16, 0, 0.0f, 0.0f, 32, 16, 32, 16);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PropertyWarpRecipe recipe, IFocusGroup focuses) {
        builder.addInputSlot(0, 0).addItemStack(InfusedPropertiesHelper.createPropertyIngredient(recipe.getInfusedProperties()));
        builder.addOutputSlot(48, 0).addItemStack(InfusedPropertiesHelper.createPropertyIngredient((List<Holder<Property>>)recipe.getResult()));
    }
}

