/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.modSupport.patchouli;

import java.util.stream.Collectors;
import net.cibernet.alchemancy.crafting.AbstractForgeRecipe;
import net.cibernet.alchemancy.crafting.ForgePropertyRecipe;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class InfusionRecipeComponentProcessor
implements IComponentProcessor {
    private AbstractForgeRecipe<?> recipe;
    private boolean hasTitle;

    public void setup(Level level, IVariableProvider variables) {
        AbstractForgeRecipe r;
        String key = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        Recipe recipe = ((RecipeHolder)level.getRecipeManager().byKey(ResourceLocation.parse((String)key)).orElseThrow(() -> new IllegalArgumentException("recipe " + key + " does not exist"))).value();
        if (!(recipe instanceof AbstractForgeRecipe)) {
            throw new IllegalArgumentException(key + " is not a valid infusion recipe");
        }
        this.recipe = r = (AbstractForgeRecipe)recipe;
        this.hasTitle = variables.has("title");
    }

    public IVariable process(Level level, String key) {
        if (key.equals("catalyst")) {
            return IVariable.from((Object)this.recipe.getCatalyst().orElse(Ingredient.EMPTY), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
        }
        if (!this.hasTitle && key.equals("title")) {
            AbstractForgeRecipe<?> abstractForgeRecipe = this.recipe;
            if (abstractForgeRecipe instanceof ForgePropertyRecipe) {
                ForgePropertyRecipe recipe1 = (ForgePropertyRecipe)abstractForgeRecipe;
                Object result = recipe1.getResult();
                return result.isEmpty() ? IVariable.from((Object)Component.translatable((String)"alchemancy.entry.infusion_removal"), (HolderLookup.Provider)level.registryAccess()) : IVariable.wrap((String)result.stream().map(propertyHolder -> ((Property)propertyHolder.value()).getName().getString()).collect(Collectors.joining(" and ")), (HolderLookup.Provider)level.registryAccess());
            }
            return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getHoverName(), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

