/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.modSupport.patchouli;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.function.UnaryOperator;
import net.cibernet.alchemancy.crafting.AbstractForgeRecipe;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.modSupport.patchouli.IngredientRingComponentBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.IVariable;

public class ItemInfusionRecipeComponent
extends IngredientRingComponentBase {
    transient AbstractForgeRecipe<?> recipe;
    @SerializedName(value="recipe")
    public String recipeName;

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider registries) {
        AbstractForgeRecipe r;
        Recipe recipe;
        this.recipeName = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeName))).asString();
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || !((recipe = ((RecipeHolder)level.getRecipeManager().byKey(ResourceLocation.parse((String)this.recipeName)).orElseThrow(() -> new IllegalArgumentException("recipe " + this.recipeName + " does not exist"))).value()) instanceof AbstractForgeRecipe)) {
            throw new IllegalArgumentException(this.recipeName + " is not a valid recipe");
        }
        this.recipe = r = (AbstractForgeRecipe)recipe;
    }

    @Override
    public void render(GuiGraphics graphics, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        super.render(graphics, context, pticks, mouseX, mouseY);
        context.renderIngredient(graphics, this.x + 24, this.y + 24, mouseX, mouseY, this.recipe.getCatalyst().orElse(Ingredient.EMPTY));
    }

    @Override
    public void build(int componentX, int componentY, int pageNum) {
        super.build(componentX, componentY, pageNum);
        this.ingredients = new ArrayList<Ingredient>(this.recipe.getInfusedProperties().stream().map(propertyHolder -> Ingredient.of((ItemStack[])new ItemStack[]{InfusedPropertiesHelper.createPropertyIngredient(propertyHolder)})).toList());
        this.ingredients.addAll(this.recipe.getInfusables());
    }
}

