/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.modSupport.patchouli;

import net.cibernet.alchemancy.crafting.ItemTransmutationRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class TransmutationComponentProcessor
implements IComponentProcessor {
    private ItemTransmutationRecipe recipe;
    private boolean hasTitle;

    public void setup(Level level, IVariableProvider variables) {
        ItemTransmutationRecipe r;
        String key = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        Recipe recipe = ((RecipeHolder)level.getRecipeManager().byKey(ResourceLocation.parse((String)key)).orElseThrow(() -> new IllegalArgumentException("recipe " + key + " does not exist"))).value();
        if (!(recipe instanceof ItemTransmutationRecipe)) {
            throw new IllegalArgumentException(key + " is not a valid transmutation recipe");
        }
        this.recipe = r = (ItemTransmutationRecipe)recipe;
        this.hasTitle = variables.has("title");
    }

    public IVariable process(Level level, String key) {
        if (key.equals("input")) {
            return IVariable.from((Object)this.recipe.getCatalyst().orElse(Ingredient.EMPTY), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
        }
        if (!this.hasTitle && key.equals("title")) {
            return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getHoverName(), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

