/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.modSupport.patchouli;

import java.util.List;
import java.util.stream.Collectors;
import net.cibernet.alchemancy.crafting.PropertyWarpRecipe;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class WarpingComponentProcessor
implements IComponentProcessor {
    private PropertyWarpRecipe recipe;
    private boolean hasTitle;

    public void setup(Level level, IVariableProvider variables) {
        PropertyWarpRecipe r;
        String key = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        Recipe recipe = ((RecipeHolder)level.getRecipeManager().byKey(ResourceLocation.parse((String)key)).orElseThrow(() -> new IllegalArgumentException("recipe " + key + " does not exist"))).value();
        if (!(recipe instanceof PropertyWarpRecipe)) {
            throw new IllegalArgumentException(key + " is not a valid warping recipe");
        }
        this.recipe = r = (PropertyWarpRecipe)recipe;
        this.hasTitle = variables.has("title");
    }

    public IVariable process(Level level, String key) {
        if (key.equals("input")) {
            return IVariable.from((Object)InfusedPropertiesHelper.createPropertyIngredient(this.recipe.getInfusedProperties()), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("output")) {
            return IVariable.from((Object)InfusedPropertiesHelper.createPropertyIngredient((List<Holder<Property>>)this.recipe.getResult()), (HolderLookup.Provider)level.registryAccess());
        }
        if (!this.hasTitle && key.equals("title")) {
            return IVariable.wrap((String)this.recipe.getResult().stream().map(propertyHolder -> ((Property)propertyHolder.value()).getDisplayText(ItemStack.EMPTY).getString()).collect(Collectors.joining(" and ")), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

