/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.network;

import net.cibernet.alchemancy.properties.SparklingProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record S2CDeathWardEffectsPayload(int entityId, ItemStack stack) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CDeathWardEffectsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, S2CDeathWardEffectsPayload::entityId, (StreamCodec)ItemStack.STREAM_CODEC, S2CDeathWardEffectsPayload::stack, S2CDeathWardEffectsPayload::new);
    public static final CustomPacketPayload.Type<S2CDeathWardEffectsPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"s2c/death_ward_effects"));

    public S2CDeathWardEffectsPayload(Entity entity, ItemStack stack) {
        this(entity.getId(), stack.copy());
    }

    public void handleDataOnMain(IPayloadContext context) {
        Level level = context.player().level();
        Entity entity = level.getEntity(this.entityId());
        Minecraft minecraft = Minecraft.getInstance();
        if (entity == null) {
            return;
        }
        minecraft.particleEngine.createTrackingEmitter(entity, SparklingProperty.getParticles(this.stack).orElse((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING), 30);
        level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TOTEM_USE, entity.getSoundSource(), 1.0f, 1.0f, false);
        if (entity == context.player()) {
            minecraft.gameRenderer.displayItemActivation(this.stack);
        }
    }

    public CustomPacketPayload.Type<S2CDeathWardEffectsPayload> type() {
        return TYPE;
    }
}

