/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.cibernet.alchemancy.registries.AlchemancyDataAttachments;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record S2CEntitySyncTintColorPayload(int entityId, List<Integer> tintColor) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2CEntitySyncTintColorPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"s2c/attachment/entity_sync_tint_color"));
    public static final StreamCodec<ByteBuf, S2CEntitySyncTintColorPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, S2CEntitySyncTintColorPayload::entityId, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), S2CEntitySyncTintColorPayload::tintColor, S2CEntitySyncTintColorPayload::new);

    public S2CEntitySyncTintColorPayload(Entity entity) {
        this(entity.getId(), (List)entity.getData(AlchemancyDataAttachments.ENTITY_TINT));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleDataOnMain(S2CEntitySyncTintColorPayload payload, IPayloadContext context) {
        Entity entity = context.player().level().getEntity(payload.entityId());
        if (entity == null) {
            return;
        }
        entity.setData(AlchemancyDataAttachments.ENTITY_TINT, payload.tintColor());
    }
}

