/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.network;

import java.util.List;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.Property;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record S2CInventoryTickPayload(int entityId, List<SlotEntry> items, int selectedSlot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2CInventoryTickPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alchemancy", (String)"s2c/inventory_tick"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CInventoryTickPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, S2CInventoryTickPayload::entityId, (StreamCodec)SlotEntry.STREAM_CODEC.apply(ByteBufCodecs.list()), S2CInventoryTickPayload::items, (StreamCodec)ByteBufCodecs.VAR_INT, S2CInventoryTickPayload::selectedSlot, S2CInventoryTickPayload::new);

    public static void handleDataOnMain(S2CInventoryTickPayload payload, IPayloadContext context) {
        Entity entity = context.player().level().getEntity(payload.entityId());
        if (entity == null) {
            return;
        }
        for (SlotEntry item : payload.items) {
            InfusedPropertiesHelper.forEachProperty(item.stack(), propertyHolder -> ((Property)propertyHolder.value()).onInventoryTick(entity, item.stack(), entity.level(), item.slot(), item.slot() == payload.selectedSlot()));
        }
    }

    public static void sendPacket(ServerPlayer player) {
        NonNullList inventory = player.getInventory().items;
        PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new S2CInventoryTickPayload(player.getId(), inventory.stream().map(stack -> new SlotEntry(inventory.indexOf(stack), (ItemStack)stack)).filter(stack -> !stack.stack().isEmpty()).toList(), player.getInventory().selected), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private record SlotEntry(int slot, ItemStack stack) {
        private static final StreamCodec<RegistryFriendlyByteBuf, SlotEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SlotEntry::slot, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, SlotEntry::stack, SlotEntry::new);
    }
}

