/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.AutosmeltProperty;
import net.cibernet.alchemancy.properties.BucketingProperty;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.WaxedProperty;
import net.cibernet.alchemancy.properties.special.ClayMoldProperty;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.cibernet.alchemancy.registries.AlchemancyTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;

public class AbsorbingProperty
extends Property {
    private static final HashMap<Predicate<ItemStack>, AbsorbingBehavior> BEHAVIORS = new HashMap<Predicate<ItemStack>, AbsorbingBehavior>(){
        {
            this.put(AbsorbingProperty.hasProperty(AlchemancyProperties.CLAY_MOLD), new AbsorbingBehavior((stack, consumeStack) -> consumeStack.is(AlchemancyTags.Items.REPAIRS_UNSHAPED_CLAY), (stack, consumeStack, player, slot) -> {
                ItemStack storedItem = ClayMoldProperty.repair((ItemStack)((ClayMoldProperty)AlchemancyProperties.CLAY_MOLD.get()).getData(stack));
                if (player.getItemBySlot(slot) == stack && stack.getCount() <= 1) {
                    player.setItemSlot(slot, storedItem);
                } else if (!player.addItem(storedItem)) {
                    player.drop(storedItem, true);
                }
                ClayMoldProperty.playRepairEffects((Entity)player);
                stack.shrink(1);
                consumeStack.shrink(1);
            }));
            this.put(AbsorbingProperty.hasProperty(AlchemancyProperties.WAXED, stack -> (Integer)((WaxedProperty)AlchemancyProperties.WAXED.get()).getData((ItemStack)stack) <= 1), new AbsorbingBehavior((stack, consumeStack) -> consumeStack.is(AlchemancyTags.Items.RESTORES_WAXED), (target, toConsume, user, slot) -> {
                ((WaxedProperty)AlchemancyProperties.WAXED.get()).removeData(target);
                WaxedProperty.playRestoreSound((LivingEntity)user);
                toConsume.shrink(1);
            }));
            this.put(AbsorbingProperty.hasProperty(AlchemancyProperties.SMELTING, stack -> (Integer)((AutosmeltProperty)AlchemancyProperties.SMELTING.get()).getData((ItemStack)stack) <= 0), new AbsorbingBehavior((stack, consumeStack) -> consumeStack.getBurnTime(RecipeType.SMELTING) > 0, (target, toConsume, user, slot) -> {
                ItemStack remainder;
                int fuel = toConsume.getBurnTime(RecipeType.SMELTING) / 200;
                if (toConsume.hasCraftingRemainingItem() && !user.addItem(remainder = toConsume.getCraftingRemainingItem())) {
                    user.drop(remainder, true);
                }
                toConsume.shrink(1);
                ((AutosmeltProperty)AlchemancyProperties.SMELTING.get()).setData(target, Integer.valueOf(fuel));
                AutosmeltProperty.playRefuelSound((Entity)user);
            }));
        }
    };
    private static final AbsorbingBehavior REPAIR = new AbsorbingBehavior((stack, consumeStack) -> stack.getItem().isValidRepairItem(stack, consumeStack), (stack, consumeStack, player, slot) -> {
        AbsorbingProperty.repairItem(stack, stack.getMaxDamage() / 4);
        consumeStack.shrink(1);
    });

    public static void registerAbsorbingBehavior(Predicate<ItemStack> baseItemPredicate, AbsorbingBehavior behavior) {
        BEHAVIORS.put(baseItemPredicate, behavior);
    }

    @Override
    public void onStackedOverMe(ItemStack otherStack, ItemStack stack, Player player, ClickAction clickAction, SlotAccess carriedSlot, Slot stackedOnSlot, AtomicBoolean isCancelled) {
        if (AbsorbingProperty.shouldRepair(stack) && stack.getItem().isValidRepairItem(stack, otherStack)) {
            AbsorbingProperty.repairItem(stack, stack.getMaxDamage() / 4);
            otherStack.shrink(1);
            isCancelled.set(true);
        }
    }

    @Override
    public void onPickUpAnyItem(Player user, ItemStack stack, EquipmentSlot slot, ItemEntity itemToPickUp, boolean canPickUp, ItemEntityPickupEvent.Pre event) {
        itemToPickUp.setNoPickUpDelay();
    }

    public static boolean scanInventoryAndConsume(ItemStack stack, Player player, EquipmentSlot slot) {
        ArrayList<AbsorbingBehavior> behaviors = new ArrayList<AbsorbingBehavior>();
        if (AbsorbingProperty.shouldRepair(stack)) {
            behaviors.add(REPAIR);
        }
        BEHAVIORS.entrySet().stream().filter(v -> ((Predicate)v.getKey()).test(stack)).map(Map.Entry::getValue).forEach(behaviors::add);
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack otherStack;
            ItemStack repairStack = otherStack = player.getInventory().getItem(i);
            ItemStack storedStack = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(repairStack);
            if (!storedStack.isEmpty()) {
                repairStack = storedStack;
            }
            for (AbsorbingBehavior behavior : behaviors) {
                if (stack == repairStack || !behavior.predicate.test(stack, repairStack)) continue;
                behavior.function.apply(stack, repairStack, player, slot);
                if (storedStack == repairStack) {
                    ((HollowProperty)AlchemancyProperties.HOLLOW.get()).setData(otherStack, storedStack);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (user instanceof Player) {
            Player player = (Player)user;
            AbsorbingProperty.scanInventoryAndConsume(stack, player, slot);
        }
        if (InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.BUCKETING) && ((BucketingProperty)AlchemancyProperties.BUCKETING.get()).isEmpty(stack)) {
            Level level = user.level();
            for (int i = 0; i <= 1; ++i) {
                Player player;
                BucketPickup bucketPickup;
                BlockPos hitPos = user.blockPosition().above(i);
                BlockState hitState = level.getBlockState(hitPos);
                Block block = hitState.getBlock();
                if (!(block instanceof BucketPickup) || !((block = (bucketPickup = (BucketPickup)block).pickupBlock(user instanceof Player ? (player = (Player)user) : null, (LevelAccessor)level, hitPos, hitState).getItem()) instanceof BucketItem)) continue;
                BucketItem bucketItem = (BucketItem)block;
                bucketPickup.getPickupSound(hitState).ifPresent(sound -> user.playSound(sound, 1.0f, 1.0f));
                level.gameEvent((Entity)user, (Holder)GameEvent.FLUID_PICKUP, hitPos);
                ((BucketingProperty)AlchemancyProperties.BUCKETING.get()).setData(stack, bucketItem.content);
                return;
            }
        }
    }

    public static boolean shouldRepair(ItemStack stack) {
        return stack.isRepairable() && AbsorbingProperty.canRepair(stack, stack.getMaxDamage() / 4);
    }

    @Override
    public int getColor(ItemStack stack) {
        return 15394909;
    }

    private static Predicate<ItemStack> hasProperty(Holder<Property> propertyHolder) {
        return AbsorbingProperty.hasProperty(propertyHolder, stack -> true);
    }

    private static Predicate<ItemStack> hasProperty(Holder<Property> propertyHolder, Predicate<ItemStack> extraCheck) {
        return extraCheck.and(stack -> InfusedPropertiesHelper.hasProperty(stack, propertyHolder));
    }

    public record AbsorbingBehavior(BiPredicate<ItemStack, ItemStack> predicate, AbsorbingConsumer function) {
    }

    public static interface AbsorbingConsumer {
        public void apply(ItemStack var1, ItemStack var2, Player var3, EquipmentSlot var4);
    }
}

