/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.properties.data.IDataHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class ArmorPulseProperty
extends Property
implements IDataHolder<Boolean> {
    @Override
    public void modifyDamageReceived(LivingEntity user, ItemStack weapon, EquipmentSlot slot, LivingDamageEvent.Pre event) {
        if (!(((Boolean)this.getData(weapon)).booleanValue() || !slot.isArmor() && user.getUseItem() != weapon || event.getSource().is(DamageTypeTags.BYPASSES_ARMOR) || event.getSource().getEntity() == null)) {
            double d = event.getSource().getEntity().distanceTo((Entity)user);
            double d2 = user.getAttributes().hasAttribute(Attributes.ENTITY_INTERACTION_RANGE) ? user.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE) : 3.0;
            if (d <= d2) {
                this.setData(weapon, Boolean.valueOf(true));
                event.setNewDamage(Math.max(0.0f, event.getNewDamage() - 1.0f));
                ArmorPulseProperty.activateByEntity((Entity)user, (Entity)user, weapon);
            }
        }
    }

    @Override
    public void onInventoryTick(Entity user, ItemStack stack, Level level, int inventorySlot, boolean isCurrentItem) {
        if (((Boolean)this.getData(stack)).booleanValue()) {
            this.setData(stack, Boolean.valueOf(false));
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return 16743264;
    }

    @Override
    public Boolean readData(CompoundTag tag) {
        return tag.getBoolean("activated");
    }

    @Override
    public CompoundTag writeData(final Boolean data) {
        return new CompoundTag(this){
            {
                this.putBoolean("activated", data);
            }
        };
    }

    @Override
    public Boolean getDefaultData() {
        return false;
    }
}

