/*
 * Decompiled with CFR 0.152.
 */
package net.cibernet.alchemancy.properties;

import java.util.HashMap;
import java.util.List;
import net.cibernet.alchemancy.blocks.blockentities.RootedItemBlockEntity;
import net.cibernet.alchemancy.item.components.InfusedPropertiesHelper;
import net.cibernet.alchemancy.properties.AssimilatingProperty;
import net.cibernet.alchemancy.properties.HollowProperty;
import net.cibernet.alchemancy.properties.Property;
import net.cibernet.alchemancy.registries.AlchemancyItems;
import net.cibernet.alchemancy.registries.AlchemancyProperties;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AssembleProperty
extends Property {
    private static final List<DataComponentType<?>> COMPONENTS_TO_CLONE = List.of((DataComponentType)AlchemancyItems.Components.INFUSED_PROPERTIES.get(), (DataComponentType)AlchemancyItems.Components.PROPERTY_DATA.get(), DataComponents.CUSTOM_NAME, DataComponents.LORE, DataComponents.ITEM_NAME, DataComponents.PROFILE, DataComponents.ENCHANTMENT_GLINT_OVERRIDE, DataComponents.BANNER_PATTERNS, DataComponents.DYED_COLOR, DataComponents.CAN_BREAK, DataComponents.CAN_PLACE_ON);

    @Override
    public void onEquippedTick(LivingEntity user, EquipmentSlot slot, ItemStack stack) {
        if (user instanceof Player) {
            boolean assimilate;
            Player player = (Player)user;
            boolean bl = assimilate = InfusedPropertiesHelper.hasProperty(stack, AlchemancyProperties.ASSIMILATING) && AssimilatingProperty.shouldRepair(stack);
            if (!assimilate && stack.getCount() >= stack.getMaxStackSize()) {
                return;
            }
            HashMap<CraftingRecipe, NonNullList> acceptedRecipes = new HashMap<CraftingRecipe, NonNullList>();
            Level level = player.level();
            RegistryAccess registryAccess = level.registryAccess();
            List<RecipeHolder<CraftingRecipe>> availableRecipes = AssembleProperty.getRecipesMatchingOutput(stack, level);
            for (RecipeHolder<CraftingRecipe> craftingRecipe : availableRecipes) {
                NonNullList acceptedSlots = NonNullList.withSize((int)player.getInventory().getContainerSize(), (Object)0);
                if (!assimilate && ((CraftingRecipe)craftingRecipe.value()).getResultItem((HolderLookup.Provider)registryAccess).getCount() + stack.getCount() > stack.getMaxStackSize()) {
                    return;
                }
                boolean accepted = true;
                for (Ingredient ingredient : ((CraftingRecipe)craftingRecipe.value()).getIngredients()) {
                    if (ingredient.isEmpty()) continue;
                    boolean hasIngredient = false;
                    for (int i = 0; i < acceptedSlots.size(); ++i) {
                        ItemStack inventoryStack = player.getInventory().getItem(i);
                        ItemStack storedItem = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(inventoryStack);
                        if (!storedItem.isEmpty()) {
                            inventoryStack = storedItem;
                        }
                        if (stack == inventoryStack || InfusedPropertiesHelper.hasProperty(inventoryStack, AlchemancyProperties.ASSEMBLING) || (Integer)acceptedSlots.get(i) >= inventoryStack.getCount() || !ingredient.test(inventoryStack)) continue;
                        hasIngredient = true;
                        acceptedSlots.set(i, (Object)((Integer)acceptedSlots.get(i) + 1));
                        break;
                    }
                    if (hasIngredient) continue;
                    accepted = false;
                    break;
                }
                if (!accepted) continue;
                acceptedRecipes.put((CraftingRecipe)craftingRecipe.value(), acceptedSlots);
            }
            if (acceptedRecipes.isEmpty()) {
                return;
            }
            CraftingRecipe selected = (CraftingRecipe)acceptedRecipes.keySet().stream().toList().get(player.getRandom().nextInt(acceptedRecipes.size()));
            NonNullList selectedList = (NonNullList)acceptedRecipes.get(selected);
            ItemStack resultItem = selected.getResultItem((HolderLookup.Provider)registryAccess).copy();
            for (DataComponentType<?> dataComponentType : COMPONENTS_TO_CLONE) {
                AssembleProperty.copyComponentTo(dataComponentType, stack, resultItem);
            }
            if (assimilate || player.getInventory().add(resultItem)) {
                if (assimilate) {
                    stack.setDamageValue(0);
                }
                for (int slotToShrink = 0; slotToShrink < player.getInventory().getContainerSize(); ++slotToShrink) {
                    if ((Integer)selectedList.get(slotToShrink) <= 0 || ((HollowProperty)AlchemancyProperties.HOLLOW.get()).shrinkContents(player.getInventory().getItem(slotToShrink), (Integer)selectedList.get(slotToShrink))) continue;
                    player.getInventory().removeItem(slotToShrink, ((Integer)selectedList.get(slotToShrink)).intValue());
                }
            }
        }
    }

    public static <T> void copyComponentTo(DataComponentType<T> componentType, ItemStack from, ItemStack to) {
        if (from.has(componentType)) {
            to.set(componentType, from.get(componentType));
        }
    }

    @Override
    @Nullable
    public ItemInteractionResult onRootedRightClick(RootedItemBlockEntity root, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Level level = player.level();
        ItemStack stack = root.getItem();
        List<RecipeHolder<CraftingRecipe>> availableRecipes = AssembleProperty.getRecipesMatchingOutput(stack, level);
        Tuple selectedRecipe = null;
        for (RecipeHolder<CraftingRecipe> craftingRecipe : availableRecipes) {
            NonNullList acceptedSlots = NonNullList.withSize((int)player.getInventory().items.size(), (Object)0);
            boolean accepted = true;
            for (Ingredient ingredient : ((CraftingRecipe)craftingRecipe.value()).getIngredients()) {
                if (ingredient.isEmpty()) continue;
                boolean hasIngredient = false;
                for (int i = 0; i < player.getInventory().items.size(); ++i) {
                    ItemStack inventoryStack = (ItemStack)player.getInventory().items.get(i);
                    ItemStack storedItem = (ItemStack)((HollowProperty)AlchemancyProperties.HOLLOW.get()).getData(inventoryStack);
                    if (!storedItem.isEmpty()) {
                        inventoryStack = storedItem;
                    }
                    if (stack == inventoryStack || InfusedPropertiesHelper.hasProperty(inventoryStack, AlchemancyProperties.ASSEMBLING) || (Integer)acceptedSlots.get(i) >= inventoryStack.getCount() || !ingredient.test(inventoryStack)) continue;
                    hasIngredient = true;
                    acceptedSlots.set(i, (Object)((Integer)acceptedSlots.get(i) + 1));
                    break;
                }
                if (hasIngredient) continue;
                accepted = false;
                break;
            }
            if (!accepted) continue;
            selectedRecipe = new Tuple((Object)((CraftingRecipe)craftingRecipe.value()), (Object)acceptedSlots);
        }
        if (selectedRecipe != null && player.addItem(((CraftingRecipe)selectedRecipe.getA()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy())) {
            NonNullList selectedList = (NonNullList)selectedRecipe.getB();
            if (!level.isClientSide()) {
                for (int slotToShrink = 0; slotToShrink < player.getInventory().items.size(); ++slotToShrink) {
                    if ((Integer)selectedList.get(slotToShrink) <= 0 || ((HollowProperty)AlchemancyProperties.HOLLOW.get()).shrinkContents(player.getInventory().getItem(slotToShrink), (Integer)selectedList.get(slotToShrink))) continue;
                    player.getInventory().removeItem(slotToShrink, ((Integer)selectedList.get(slotToShrink)).intValue());
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.onRootedRightClick(root, player, hand, hitResult);
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipesMatchingOutput(ItemStack output, Level level) {
        return level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().filter(craftingRecipe -> ItemStack.isSameItem((ItemStack)((CraftingRecipe)craftingRecipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()), (ItemStack)output) && !((CraftingRecipe)craftingRecipe.value()).getIngredients().isEmpty()).toList();
    }

    @Override
    public int getColor(ItemStack stack) {
        return 10512068;
    }
}

